/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;
import org.primefaces.selenium.AbstractPrimePage;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.internal.junit.BootstrapExtension;
import org.primefaces.selenium.internal.junit.PageInjectionExtension;
import org.primefaces.selenium.internal.junit.WebDriverExtension;
import org.primefaces.selenium.spi.WebDriverProvider;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Extensions(value={@ExtendWith(value={BootstrapExtension.class}), @ExtendWith(value={WebDriverExtension.class}), @ExtendWith(value={PageInjectionExtension.class})})
public abstract class AbstractPrimePageTest {
    @BeforeEach
    public void beforeEach() {
        this.clearConsole();
    }

    protected void assertPresent(WebElement element) {
        if (!PrimeSelenium.isElementPresent(element)) {
            Assertions.fail((String)"Element should be present!");
        }
    }

    protected void assertPresent(By by) {
        if (!PrimeSelenium.isElementPresent(by)) {
            Assertions.fail((String)"Element should be present!");
        }
    }

    protected void assertNotPresent(WebElement element) {
        if (PrimeSelenium.isElementPresent(element)) {
            Assertions.fail((String)"Element should not be present!");
        }
    }

    protected void assertNotPresent(By by) {
        if (PrimeSelenium.isElementPresent(by)) {
            Assertions.fail((String)"Element should not be present!");
        }
    }

    protected void assertDisplayed(WebElement element) {
        if (!PrimeSelenium.isElementDisplayed(element)) {
            Assertions.fail((String)"Element should be displayed!");
        }
    }

    protected void assertDisplayed(By by) {
        if (!PrimeSelenium.isElementDisplayed(by)) {
            Assertions.fail((String)"Element should be displayed!");
        }
    }

    protected void assertNotDisplayed(WebElement element) {
        if (PrimeSelenium.isElementDisplayed(element)) {
            Assertions.fail((String)"Element should not be displayed!");
        }
    }

    protected void assertNotDisplayed(By by) {
        if (PrimeSelenium.isElementDisplayed(by)) {
            Assertions.fail((String)"Element should not be displayed!");
        }
    }

    protected void assertEnabled(WebElement element) {
        if (!PrimeSelenium.isElementEnabled(element)) {
            Assertions.fail((String)"Element should be enabled!");
        }
    }

    protected void assertEnabled(By by) {
        if (!PrimeSelenium.isElementEnabled(by)) {
            Assertions.fail((String)"Element should be enabled!");
        }
    }

    protected void assertNotEnabled(WebElement element) {
        if (PrimeSelenium.isElementEnabled(element)) {
            Assertions.fail((String)"Element should not be enabled!");
        }
    }

    protected void assertNotEnabled(By by) {
        if (PrimeSelenium.isElementEnabled(by)) {
            Assertions.fail((String)"Element should not be enabled!");
        }
    }

    protected void assertDisabled(WebElement element) {
        if (PrimeSelenium.isElementEnabled(element)) {
            Assertions.fail((String)"Element should be disabled!");
        }
    }

    protected void assertDisabled(By by) {
        if (PrimeSelenium.isElementEnabled(by)) {
            Assertions.fail((String)"Element should be disabled!");
        }
    }

    protected void assertNotDisabled(WebElement element) {
        if (!PrimeSelenium.isElementEnabled(element)) {
            Assertions.fail((String)"Element should not be disabled!");
        }
    }

    protected void assertNotDisabled(By by) {
        if (!PrimeSelenium.isElementEnabled(by)) {
            Assertions.fail((String)"Element should not be disabled!");
        }
    }

    protected void assertIsAt(AbstractPrimePage page) {
        this.assertIsAt(page.getLocation());
    }

    protected void assertClickable(WebElement element) {
        if (!PrimeSelenium.isElementClickable(element)) {
            Assertions.fail((String)"Element should be clickable!");
        }
    }

    protected void assertNotClickable(WebElement element) {
        if (PrimeSelenium.isElementClickable(element)) {
            Assertions.fail((String)"Element should not be clickable!");
        }
    }

    protected void assertIsAt(Class<? extends AbstractPrimePage> pageClass) {
        String location;
        try {
            location = PrimeSelenium.getUrl(pageClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.assertIsAt(location);
    }

    protected void assertNoJavascriptErrors() {
        LogEntries logEntries = this.getLogsForType("browser");
        if (logEntries == null) {
            return;
        }
        List severe = logEntries.getAll().stream().filter(l -> l.getLevel() == Level.SEVERE).collect(Collectors.toList());
        Assertions.assertTrue((boolean)severe.isEmpty(), (String)("Javascript errors were detected in the browser console.\r\n" + severe.toString()));
    }

    protected void clearConsole() {
        PrimeSelenium.executeScript("console.clear();", new Object[0]);
        this.getLogsForType("browser");
    }

    protected void printConsole() {
        LogEntries logEntries = this.getLogsForType("browser");
        if (logEntries == null) {
            return;
        }
        for (LogEntry log : logEntries) {
            if (log.getLevel() == Level.SEVERE) {
                System.err.println(log.getMessage());
                continue;
            }
            System.out.println(log.getMessage());
        }
    }

    protected LogEntries getLogsForType(String type) {
        if (!this.isConsoleSupported()) {
            return null;
        }
        Logs logs = this.getWebDriver().manage().logs();
        if (logs == null) {
            return null;
        }
        Set types = logs.getAvailableLogTypes();
        if (!types.contains("browser")) {
            return null;
        }
        return logs.get(type);
    }

    private boolean isConsoleSupported() {
        return !PrimeSelenium.isFirefox() && !PrimeSelenium.isSafari();
    }

    protected void assertIsAt(String relativePath) {
        Assertions.assertTrue((boolean)this.getWebDriver().getCurrentUrl().contains(relativePath));
    }

    protected <T extends AbstractPrimePage> T goTo(Class<T> pageClass) {
        return PrimeSelenium.goTo(pageClass);
    }

    protected void goTo(String partialUrl) {
        PrimeSelenium.goTo(partialUrl);
    }

    protected WebDriver getWebDriver() {
        return WebDriverProvider.get();
    }

    protected void assertText(WebElement element, String text) {
        String actual = AbstractPrimePageTest.normalizeSpace(element.getText()).trim();
        String expected = AbstractPrimePageTest.normalizeSpace(text).trim();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    protected void assertCss(WebElement element, String ... cssClasses) {
        String elementClass = element.getAttribute("class");
        if (elementClass == null) {
            Assertions.fail((String)"Element did not have CSS 'class' attribute.");
            return;
        }
        String[] elementClasses = elementClass.split(" ");
        boolean result = true;
        for (String expected : cssClasses) {
            boolean found = false;
            for (String actual : elementClasses) {
                if (!actual.equalsIgnoreCase(expected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assertions.fail((String)("Element expected CSS class '" + expected + "' but was not found in '" + elementClass + "'."));
            break;
        }
    }

    public static String normalizeSpace(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int size = str.length();
        char[] newChars = new char[size];
        int count = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i = 0; i < size; ++i) {
            char actualChar = str.charAt(i);
            boolean isWhitespace = Character.isWhitespace(actualChar);
            if (isWhitespace) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count++] = " ".charAt(0);
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return "";
        }
        return new String(newChars, 0, count - (whitespacesCount > 0 ? 1 : 0)).trim();
    }
}

