/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium;

import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.support.decorators.WebDriverDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.primefaces.selenium.AbstractPrimePage;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.internal.ConfigProvider;
import org.primefaces.selenium.internal.Guard;
import org.primefaces.selenium.spi.DeploymentAdapter;
import org.primefaces.selenium.spi.PrimePageFactory;
import org.primefaces.selenium.spi.PrimePageFragmentFactory;
import org.primefaces.selenium.spi.WebDriverProvider;

public final class PrimeSelenium {
    private static final String HEADLESS_MODE_SYSPROP_NAME = "webdriver.headless";
    private static final String HEADLESS_MODE_SYSPROP_VAL_DEFAULT = "false";

    private PrimeSelenium() {
    }

    public static WebDriver getWebDriver() {
        return WebDriverProvider.get();
    }

    public static <T extends WebElement> T createFragment(Class<T> fragmentClass, final By by) {
        return PrimePageFragmentFactory.create(fragmentClass, new ElementLocator(){

            public WebElement findElement() {
                return PrimeSelenium.getWebDriver().findElement(by);
            }

            public List<WebElement> findElements() {
                return PrimeSelenium.getWebDriver().findElements(by);
            }
        });
    }

    public static <T extends WebElement> T createFragment(Class<T> fragmentClass, WebElement element) {
        return PrimePageFragmentFactory.create(fragmentClass, element);
    }

    public static <T extends AbstractPrimePage> T goTo(Class<T> pageClass) {
        WebDriver driver = WebDriverProvider.get();
        T page = PrimePageFactory.create(pageClass, driver);
        driver.get(PrimeSelenium.getUrl(page));
        if (PrimeSelenium.isSafari()) {
            PrimeSelenium.wait(500);
        }
        return page;
    }

    public static void goTo(AbstractPrimePage page) {
        WebDriver driver = WebDriverProvider.get();
        driver.get(PrimeSelenium.getUrl(page));
        if (PrimeSelenium.isSafari()) {
            PrimeSelenium.wait(500);
        }
    }

    public static void goTo(String partialUrl) {
        WebDriver driver = WebDriverProvider.get();
        driver.get(PrimeSelenium.getUrl(partialUrl));
        if (PrimeSelenium.isSafari()) {
            PrimeSelenium.wait(500);
        }
    }

    public static String getUrl(AbstractPrimePage page) {
        DeploymentAdapter deploymentAdapter = ConfigProvider.getInstance().getDeploymentAdapter();
        String baseLocation = page.getBaseLocation();
        if (deploymentAdapter != null) {
            baseLocation = PrimeSelenium.getBaseUrl();
        }
        return baseLocation + page.getLocation();
    }

    public static String getUrl(String url) {
        return PrimeSelenium.getBaseUrl() + url;
    }

    public static String getBaseUrl() {
        DeploymentAdapter deploymentAdapter = ConfigProvider.getInstance().getDeploymentAdapter();
        if (deploymentAdapter != null) {
            return deploymentAdapter.getBaseUrl();
        }
        return ConfigProvider.getInstance().getDeploymentBaseUrl();
    }

    public static boolean hasCssClass(WebElement element, String ... cssClass) {
        String elementClass = element.getAttribute("class");
        if (elementClass == null) {
            return false;
        }
        String[] elementClasses = elementClass.split(" ");
        boolean result = true;
        for (String expected : cssClass) {
            boolean found = false;
            for (String actual : elementClasses) {
                if (!actual.equalsIgnoreCase(expected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isElementPresent(By by) {
        try {
            PrimeSelenium.getWebDriver().findElement(by);
            return true;
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            return false;
        }
    }

    public static boolean isElementPresent(WebElement element) {
        try {
            element.isDisplayed();
            return true;
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            return false;
        }
    }

    public static boolean isElementDisplayed(By by) {
        try {
            return PrimeSelenium.getWebDriver().findElement(by).isDisplayed();
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            return false;
        }
    }

    public static boolean isElementDisplayed(WebElement element) {
        try {
            return element.isDisplayed();
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            return false;
        }
    }

    public static boolean isElementEnabled(By by) {
        try {
            return PrimeSelenium.getWebDriver().findElement(by).isEnabled();
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            return false;
        }
    }

    public static boolean isElementEnabled(WebElement element) {
        try {
            return element.isEnabled() && !PrimeSelenium.hasCssClass(element, "ui-state-disabled");
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            return false;
        }
    }

    public static boolean isElementClickable(WebElement element) {
        return PrimeSelenium.isElementDisplayed(element) && PrimeSelenium.isElementEnabled(element) && !PrimeSelenium.hasCssClass(element, "ui-state-disabled") && !Boolean.parseBoolean(element.getAttribute("aria-busy"));
    }

    public static <T> T guardHttp(T target) {
        return Guard.http(target);
    }

    public static <T> T guardAjax(T target) {
        return Guard.ajax(target);
    }

    public static <T> T guardAjax(T target, int delayInMilliseconds) {
        return Guard.ajax(target, delayInMilliseconds);
    }

    public static <T> T guardAjax(String script, Object ... args) {
        return Guard.ajax(script, args);
    }

    public static <T> T executeScript(String script, Object ... args) {
        JavascriptExecutor executor = (JavascriptExecutor)PrimeSelenium.getWebDriver();
        Object t = executor.executeScript(script, args);
        if (PrimeSelenium.isSafari()) {
            PrimeSelenium.wait(50);
        }
        return (T)t;
    }

    public static <T> T executeScript(boolean isAjaxified, String script, Object ... args) {
        if (isAjaxified) {
            return PrimeSelenium.guardAjax(script, args);
        }
        return PrimeSelenium.executeScript(script, args);
    }

    public static WebDriverWait waitGui() {
        ConfigProvider config = ConfigProvider.getInstance();
        WebDriver driver = WebDriverProvider.get();
        WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(config.getTimeoutGui()), Duration.ofMillis(100L));
        return wait;
    }

    public static WebDriverWait waitDocumentLoad() {
        ConfigProvider config = ConfigProvider.getInstance();
        WebDriver driver = WebDriverProvider.get();
        WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(config.getTimeoutDocumentLoad()), Duration.ofMillis(100L));
        wait.until(PrimeExpectedConditions.documentLoaded());
        return wait;
    }

    public static void disableAnimations() {
        PrimeSelenium.executeScript("if (window.PrimeFaces) { $(function() { PrimeFaces.utils.disableAnimations(); }); }", new Object[0]);
    }

    public static void enableAnimations() {
        PrimeSelenium.executeScript("if (window.PrimeFaces) { $(function() { PrimeFaces.utils.enableAnimations(); }); }", new Object[0]);
    }

    public static void setHiddenInput(WebElement input, String value) {
        PrimeSelenium.executeScript(" document.getElementById('" + input.getAttribute("id") + "').value='" + value + "'", new Object[0]);
    }

    public static void clearInput(WebElement input, boolean isAjaxified) {
        if (PrimeSelenium.isSafari()) {
            String inputText = input.getAttribute("value");
            if (inputText != null && inputText.length() > 0) {
                CharSequence[] clearText = new CharSequence[inputText.length()];
                for (int i = 0; i < inputText.length(); ++i) {
                    clearText[i] = Keys.BACK_SPACE;
                }
                if (isAjaxified) {
                    PrimeSelenium.guardAjax(input).sendKeys(clearText);
                } else {
                    input.sendKeys(clearText);
                }
            }
        } else {
            Keys command = PrimeSelenium.isMacOs() ? Keys.COMMAND : Keys.CONTROL;
            input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "a"})});
            if (isAjaxified) {
                PrimeSelenium.guardAjax(input).sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            } else {
                input.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            }
        }
    }

    public static boolean isChrome() {
        Capabilities cap = PrimeSelenium.getCapabilities();
        return "Chrome".equalsIgnoreCase(cap.getBrowserName());
    }

    public static boolean isFirefox() {
        Capabilities cap = PrimeSelenium.getCapabilities();
        return "Firefox".equalsIgnoreCase(cap.getBrowserName());
    }

    public static boolean isSafari() {
        Capabilities cap = PrimeSelenium.getCapabilities();
        return "Safari".equalsIgnoreCase(cap.getBrowserName());
    }

    public static boolean isMacOs() {
        String os = System.getProperty("os.name").toUpperCase();
        return os.contains("DARWIN") || os.contains("MAC");
    }

    public static boolean isHeadless() {
        return Boolean.parseBoolean(System.getProperty(HEADLESS_MODE_SYSPROP_NAME, HEADLESS_MODE_SYSPROP_VAL_DEFAULT));
    }

    public static void wait(int milliseconds) {
        if (milliseconds > 0) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException ex) {
                System.err.println("Wait was interrupted!");
                Thread.currentThread().interrupt();
            }
        }
    }

    public static WebStorage getWebStorage() {
        WebDriver webDriver = PrimeSelenium.getWebDriver();
        if (webDriver instanceof WebDriverDecorator) {
            WebDriverDecorator driver = (WebDriverDecorator)webDriver;
            webDriver = (WebDriver)driver.getDecoratedDriver().getOriginal();
        }
        if (webDriver instanceof WebStorage) {
            return (WebStorage)webDriver;
        }
        return null;
    }

    public static Capabilities getCapabilities() {
        WebDriver webDriver = PrimeSelenium.getWebDriver();
        if (webDriver instanceof WebDriverDecorator) {
            WebDriverDecorator driver = (WebDriverDecorator)webDriver;
            webDriver = (WebDriver)driver.getDecoratedDriver().getOriginal();
        }
        if (webDriver instanceof HasCapabilities) {
            return ((HasCapabilities)webDriver).getCapabilities();
        }
        return null;
    }
}

