/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.internal.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.primefaces.selenium.spi.PrimePageFragmentFactory;

public class ElementsLocatorInterceptor
implements InvocationHandler {
    private final ElementLocator locator;
    private final Class<? extends WebElement> genericClass;

    public ElementsLocatorInterceptor(ElementLocator locator, Class<? extends WebElement> genericClass) {
        this.locator = locator;
        this.genericClass = genericClass;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
        ArrayList<WebElement> elements = this.locator.findElements();
        if (this.genericClass != WebElement.class) {
            ArrayList<WebElement> fragments = new ArrayList<WebElement>();
            for (int i = 0; i < elements.size(); ++i) {
                WebElement element = (WebElement)elements.get(i);
                WebElement fragment = PrimePageFragmentFactory.create(this.genericClass, element, new IndexedElementLocator(this.locator, i));
                fragments.add(fragment);
            }
            elements = fragments;
        }
        try {
            return method.invoke((Object)elements, objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static class IndexedElementLocator
    implements ElementLocator {
        private final ElementLocator locator;
        private final int i;

        public IndexedElementLocator(ElementLocator locator, int i) {
            this.locator = locator;
            this.i = i;
        }

        public WebElement findElement() {
            return (WebElement)this.locator.findElements().get(this.i);
        }

        public List<WebElement> findElements() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

