/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.internal;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.util.logging.Level;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.primefaces.selenium.internal.ConfigProvider;
import org.primefaces.selenium.spi.WebDriverAdapter;

public class DefaultWebDriverAdapter
implements WebDriverAdapter {
    @Override
    public void initialize(ConfigProvider configProvider) {
        WebDriverManager webDriverManager = null;
        if ("firefox".equals(configProvider.getWebdriverBrowser())) {
            if (!System.getProperties().contains("webdriver.gecko.driver")) {
                webDriverManager = WebDriverManager.firefoxdriver();
            }
        } else if ("chrome".equals(configProvider.getWebdriverBrowser())) {
            if (!System.getProperties().contains("webdriver.chrome.driver")) {
                webDriverManager = WebDriverManager.chromedriver();
            }
        } else if ("safari".equals(configProvider.getWebdriverBrowser()) && !System.getProperties().contains("webdriver.safari.driver")) {
            webDriverManager = WebDriverManager.safaridriver();
        }
        if (webDriverManager != null) {
            if (configProvider.getWebdriverVersion() != null) {
                webDriverManager = webDriverManager.driverVersion(configProvider.getWebdriverVersion());
            }
            webDriverManager.setup();
        }
    }

    @Override
    public WebDriver createWebDriver() {
        ConfigProvider config = ConfigProvider.getInstance();
        if (config.getWebdriverBrowser() == null) {
            throw new RuntimeException("No webdriver.browser configured; Please either configure it or implement WebDriverAdapter#getWebDriver!");
        }
        switch (config.getWebdriverBrowser()) {
            case "firefox": {
                FirefoxOptions firefoxOptions = new FirefoxOptions();
                firefoxOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                firefoxOptions.setHeadless(config.isWebdriverHeadless());
                return new FirefoxDriver(firefoxOptions);
            }
            case "chrome": {
                ChromeOptions chromeOptions = new ChromeOptions();
                chromeOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                chromeOptions.setHeadless(config.isWebdriverHeadless());
                LoggingPreferences logPrefs = new LoggingPreferences();
                logPrefs.enable("browser", Level.ALL);
                chromeOptions.setCapability("goog:loggingPrefs", (Object)logPrefs);
                chromeOptions.setExperimentalOption("w3c", (Object)false);
                return new ChromeDriver(chromeOptions);
            }
            case "safari": {
                SafariOptions safariOptions = new SafariOptions();
                safariOptions.setCapability("safari:diagnose", "true");
                return new SafariDriver(safariOptions);
            }
        }
        throw new RuntimeException("Current supported browsers are: safari, firefox, chrome");
    }
}

