/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.io.Serializable;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.InputText;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class Spinner
extends InputText {
    @FindByParentPartialId(value="_input")
    private WebElement input;
    @FindBy(css=".ui-spinner-up")
    private WebElement buttonUp;
    @FindBy(css=".ui-spinner-down")
    private WebElement buttonDown;

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getButtonUp() {
        return this.buttonUp;
    }

    public WebElement getButtonDown() {
        return this.buttonDown;
    }

    @Override
    public void setValue(Serializable value) {
        if (value == null) {
            value = "\"\"";
        }
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".setValue(" + value.toString() + ")"), (Object[])new Object[0]);
    }

    public void increment() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".spin(1);"), (Object[])new Object[0]);
    }

    public void decrement() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".spin(-1);"), (Object[])new Object[0]);
    }

    public void change() {
        PrimeSelenium.executeScript((boolean)this.isOnchangeAjaxified(), (String)(this.getWidgetByIdScript() + ".input.trigger('change');"), (Object[])new Object[0]);
    }
}

