/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class Calendar
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public boolean isDateSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "dateSelect");
    }

    public boolean isViewChangeAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "viewChange");
    }

    public boolean isCloseAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "close");
    }

    public LocalDateTime getValue() {
        Object date = PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate()"), (Object[])new Object[0]);
        if (date == null) {
            return null;
        }
        long timeZoneOffset = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getTimezoneOffset()"), (Object[])new Object[0]);
        String utcTimeString = (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().toUTCString();"), (Object[])new Object[0]);
        return LocalDateTime.parse(utcTimeString, DateTimeFormatter.RFC_1123_DATE_TIME).minusMinutes(timeZoneOffset);
    }

    public LocalDate getValueAsLocalDate() {
        Object date = PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate()"), (Object[])new Object[0]);
        if (date == null) {
            return null;
        }
        Long dayOfMonth = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getDate();"), (Object[])new Object[0]);
        Long month = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getMonth();"), (Object[])new Object[0]);
        Long year = (Long)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate().getFullYear();"), (Object[])new Object[0]);
        return LocalDate.of(year.intValue(), month.intValue() + 1, dayOfMonth.intValue());
    }

    public void setValue(LocalDate localDate) {
        this.setValue(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public void setValue(LocalDateTime dateTime) {
        int timezoneOffset = (int)this.getTimezoneOffset();
        int timezoneOffsetHours = timezoneOffset / 60;
        int timezoneOffsetMinutes = timezoneOffset % 60;
        ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutes(timezoneOffsetHours, timezoneOffsetMinutes);
        long millis = dateTime.atOffset(zoneOffset).toInstant().toEpochMilli();
        this.setValue(millis);
    }

    public void setValue(long millis) {
        if (PrimeSelenium.isSafari()) {
            this.setDate(millis);
        } else {
            String formattedDate = this.millisAsFormattedDate(millis);
            this.selectAllText();
            if (this.isViewChangeAjaxified()) {
                ((WebElement)PrimeSelenium.guardAjax((Object)this.getInput())).sendKeys(new CharSequence[]{formattedDate});
            } else {
                this.getInput().sendKeys(new CharSequence[]{formattedDate});
            }
            if (this.isOnchangeAjaxified()) {
                ((WebElement)PrimeSelenium.guardAjax((Object)this.getInput())).sendKeys(new CharSequence[]{Keys.TAB});
            } else {
                this.getInput().sendKeys(new CharSequence[]{Keys.TAB});
            }
        }
    }

    public void setDate(LocalDateTime dateTime) {
        long millis = dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        this.setDate(millis);
    }

    public void setDate(long epoch) {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".setDate(new Date(" + epoch + "));"), (Object[])new Object[0]);
    }

    public String getWidgetDate() {
        return (String)PrimeSelenium.executeScript((String)("return " + this.getWidgetByIdScript() + ".getDate();"), (Object[])new Object[0]);
    }

    public String millisAsFormattedDate(long millis) {
        return (String)PrimeSelenium.executeScript((String)("return $.datepicker.formatDate(" + this.getWidgetByIdScript() + ".cfg.dateFormat, new Date(" + millis + "));"), (Object[])new Object[0]);
    }

    public long getTimezoneOffset() {
        return (Long)PrimeSelenium.executeScript((String)"return new Date().getTimezoneOffset();", (Object[])new Object[0]);
    }
}

