/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractPageableData;

public abstract class DataView
extends AbstractPageableData {
    @FindBy(className="ui-dataview")
    private WebElement webElement;
    @FindBy(className="ui-dataview-header")
    private WebElement header;
    @FindBy(className="ui-dataview-content")
    private WebElement content;

    @Override
    public List<WebElement> getRowsWebElement() {
        if (this.getActiveLayout() == Layout.LIST) {
            return this.content.findElements(By.className((String)"ui-dataview-row"));
        }
        return this.content.findElements(By.className((String)"ui-dataview-column"));
    }

    public WebElement getRowWebElement(int index) {
        return this.getRowsWebElement().get(index);
    }

    public WebElement getLayoutOptionsWebElement() {
        return this.header.findElement(By.className((String)"ui-dataview-layout-options"));
    }

    public Layout getActiveLayout() {
        List layoutButtons = this.getLayoutOptionsWebElement().findElements(By.className((String)"ui-button"));
        for (WebElement layoutButton : layoutButtons) {
            WebElement layoutButtonInputHidden = layoutButton.findElement(By.tagName((String)"input"));
            if (!"true".equals(layoutButtonInputHidden.getAttribute("checked"))) continue;
            if ("list".equals(layoutButtonInputHidden.getAttribute("value"))) {
                return Layout.LIST;
            }
            return Layout.GRID;
        }
        return null;
    }

    public void setActiveLayout(Layout layout) {
        List layoutButtons = this.getLayoutOptionsWebElement().findElements(By.className((String)"ui-button"));
        for (WebElement layoutButton : layoutButtons) {
            WebElement layoutButtonInputHidden = layoutButton.findElement(By.tagName((String)"input"));
            if (layout == Layout.LIST && "list".equals(layoutButtonInputHidden.getAttribute("value"))) {
                ((WebElement)PrimeSelenium.guardAjax((Object)layoutButton)).click();
                continue;
            }
            if (layout != Layout.GRID || !"grid".equals(layoutButtonInputHidden.getAttribute("value"))) continue;
            ((WebElement)PrimeSelenium.guardAjax((Object)layoutButton)).click();
        }
    }

    public static enum Layout {
        LIST,
        GRID;

    }
}

