/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.replacer;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.Base64;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.primefaces.extensions.optimizerplugin.replacer.TokenResolver;

public class DataUriTokenResolver
implements TokenResolver {
    public final List<File> imagesDir;
    private final Log log;
    private static final Pattern PATTERN = Pattern.compile("[\\s'\":/\\\\]+");
    private static final Map<String, String> supportedTypes = new HashMap<String, String>();

    public DataUriTokenResolver(Log log, List<File> imagesDir) {
        this.imagesDir = imagesDir;
        this.log = log;
    }

    @Override
    public String resolveToken(String token) throws IOException {
        String[] pathParts;
        if (token == null || token.length() < 1) {
            return token;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Resolving resource " + token));
        }
        if ((pathParts = PATTERN.split(token)) == null || pathParts.length < 1) {
            return null;
        }
        String separator = System.getProperty("file.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(separator);
        for (int i = 0; i < pathParts.length; ++i) {
            if (!StringUtils.isNotBlank((String)pathParts[i])) continue;
            sb.append(pathParts[i]);
            if (i + 1 >= pathParts.length) continue;
            sb.append(separator);
        }
        String path = sb.toString();
        if (path.length() == 1) {
            return null;
        }
        if (path.endsWith(separator)) {
            path = path.substring(0, path.length() - 1);
        }
        boolean found = false;
        File imageFile = null;
        String extension = null;
        for (File imageDir : this.imagesDir) {
            String fullPath;
            if (!imageDir.isDirectory() || !(imageFile = new File(fullPath = imageDir.getCanonicalPath() + path)).exists() || !supportedTypes.containsKey(extension = FileUtils.extension((String)fullPath))) continue;
            found = true;
            break;
        }
        if (!found) {
            this.log.warn((CharSequence)("Failed to resolve resource: " + token + (String)(this.imagesDir.size() == 1 ? " at " + String.valueOf(imageFile) : "")));
            return null;
        }
        this.log.info((CharSequence)("Data URI conversion for: " + String.valueOf(imageFile)));
        byte[] bytes = Files.toByteArray(imageFile);
        return "data:" + supportedTypes.get(extension) + ";base64," + new String(Base64.encodeBase64((byte[])bytes));
    }

    static {
        supportedTypes.put("gif", "image/gif");
        supportedTypes.put("jpg", "image/jpeg");
        supportedTypes.put("jpeg", "image/jpeg");
        supportedTypes.put("png", "image/png");
        supportedTypes.put("svg", "image/svg+xml");
        supportedTypes.put("webp", "image/webp");
    }
}

