/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.dynaform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.primefaces.extensions.model.dynaform.AbstractDynaFormElement;
import org.primefaces.extensions.model.dynaform.DynaFormControl;
import org.primefaces.extensions.model.dynaform.DynaFormLabel;
import org.primefaces.extensions.model.dynaform.DynaFormRow;

public class DynaFormModel
implements Serializable {
    private static final long serialVersionUID = 20120514L;
    private final String uuid;
    private final List<DynaFormRow> regularRows = new ArrayList<DynaFormRow>();
    private List<DynaFormRow> extendedRows = null;
    private final List<DynaFormLabel> labels = new ArrayList<DynaFormLabel>();
    private final List<DynaFormControl> controls = new ArrayList<DynaFormControl>();

    public DynaFormModel() {
        this.uuid = UUID.randomUUID().toString();
    }

    public String getUuid() {
        return this.uuid;
    }

    public List<DynaFormRow> getRegularRows() {
        return this.regularRows;
    }

    public List<DynaFormRow> getExtendedRows() {
        return this.extendedRows;
    }

    public List<DynaFormControl> getControls() {
        return this.controls;
    }

    public List<DynaFormLabel> getLabels() {
        return this.labels;
    }

    public DynaFormRow createRegularRow() {
        DynaFormRow dynaFormRow = new DynaFormRow(this.regularRows.size() + 1, false, this);
        this.regularRows.add(dynaFormRow);
        return dynaFormRow;
    }

    public DynaFormRow createExtendedRow() {
        if (this.extendedRows == null) {
            this.extendedRows = new ArrayList<DynaFormRow>();
        }
        DynaFormRow dynaFormRow = new DynaFormRow(this.extendedRows.size() + 1, true, this);
        this.extendedRows.add(dynaFormRow);
        return dynaFormRow;
    }

    public void removeRegularRow(DynaFormRow rowToBeRemoved) {
        int idx;
        int n = idx = rowToBeRemoved != null ? this.regularRows.indexOf(rowToBeRemoved) : -1;
        if (idx >= 0) {
            this.removeRow(this.regularRows, rowToBeRemoved, idx);
        }
    }

    public void removeRegularRow(int idx) {
        DynaFormRow rowToBeRemoved = null;
        if (0 <= idx && idx < this.regularRows.size()) {
            rowToBeRemoved = this.regularRows.get(idx);
        }
        if (rowToBeRemoved != null) {
            this.removeRow(this.regularRows, rowToBeRemoved, idx);
        }
    }

    public void removeExtendedRow(DynaFormRow rowToBeRemoved) {
        int idx;
        int n = idx = rowToBeRemoved != null ? this.extendedRows.indexOf(rowToBeRemoved) : -1;
        if (idx >= 0) {
            this.removeRow(this.extendedRows, rowToBeRemoved, idx);
        }
    }

    public void removeExtendedRow(int idx) {
        DynaFormRow rowToBeRemoved = null;
        if (0 <= idx && idx < this.extendedRows.size()) {
            rowToBeRemoved = this.extendedRows.get(idx);
        }
        if (rowToBeRemoved != null) {
            this.removeRow(this.extendedRows, rowToBeRemoved, idx);
        }
    }

    private void removeRow(List<DynaFormRow> rows, DynaFormRow rowToBeRemoved, int idx) {
        ArrayList<DynaFormControl> controlsToBeRemoved = new ArrayList<DynaFormControl>();
        ArrayList<DynaFormLabel> labelsToBeRemoved = new ArrayList<DynaFormLabel>();
        for (AbstractDynaFormElement element : rowToBeRemoved.getElements()) {
            if (element instanceof DynaFormControl) {
                controlsToBeRemoved.add((DynaFormControl)element);
                continue;
            }
            if (!(element instanceof DynaFormLabel)) continue;
            labelsToBeRemoved.add((DynaFormLabel)element);
        }
        this.controls.removeAll(controlsToBeRemoved);
        this.labels.removeAll(labelsToBeRemoved);
        for (DynaFormLabel label : this.labels) {
            if (label.getForControl() == null || !controlsToBeRemoved.contains(label.getForControl())) continue;
            label.setForControl(null);
        }
        rows.remove(rowToBeRemoved);
        int row = idx;
        List<DynaFormRow> rowsToBeAdjusted = rows.subList(idx, rows.size());
        for (DynaFormRow dynaFormRow : rowsToBeAdjusted) {
            dynaFormRow.setRow(++row);
            for (AbstractDynaFormElement element : dynaFormRow.getElements()) {
                element.setRow(row);
                if (!(element instanceof DynaFormControl)) continue;
                DynaFormControl control = (DynaFormControl)element;
                int delta = rowToBeRemoved.getElements().size();
                control.setPosition(control.getPosition() - delta);
                control.generateKey();
            }
        }
    }

    public boolean isExistExtendedGrid() {
        return this.getExtendedRows() != null && !this.getExtendedRows().isEmpty();
    }
}

