/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.osmap;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.osmap.OSMap;
import org.primefaces.model.map.Circle;
import org.primefaces.model.map.LatLng;
import org.primefaces.model.map.MapModel;
import org.primefaces.model.map.Marker;
import org.primefaces.model.map.Polygon;
import org.primefaces.model.map.Polyline;
import org.primefaces.model.map.Rectangle;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class OSMapRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        OSMap map = (OSMap)component;
        this.encodeMarkup(facesContext, map);
        this.encodeScript(facesContext, map);
    }

    protected void encodeMarkup(FacesContext context, OSMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = map.getClientId(context);
        writer.startElement("div", (UIComponent)map);
        writer.writeAttribute("id", (Object)(clientId + "_map"), null);
        if (map.getStyle() != null) {
            writer.writeAttribute("style", (Object)map.getStyle(), null);
        }
        if (map.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)map.getStyleClass(), null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, OSMap map) throws IOException {
        String[] parts = map.getCenter().split(",");
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("OSMap", (UIComponent)map);
        wb.attr("center", map.getCenter());
        wb.nativeAttr("map", "L.map('" + map.getClientId() + "_map', { dragging: " + map.isDraggable() + ", zoomControl: " + map.isZoomControl() + ", scrollWheelZoom: " + map.isScrollWheel() + " } ).setView(['" + parts[0].trim() + "', '" + parts[1].trim() + "'], " + map.getZoom() + ")");
        String tileUrl = "https://tile.openstreetmap.org/{z}/{x}/{y}.png";
        String attribution = "&copy; <a href=\"https://www.openstreetmap.org/copyright\">OpenStreetMap</a>";
        if (map.getTileUrl() != null) {
            tileUrl = map.getTileUrl();
        }
        if (map.getAttribution() != null) {
            attribution = map.getAttribution();
        }
        wb.nativeAttr("tile", "L.tileLayer('" + tileUrl + "', { attribution: '" + attribution + "' })");
        this.encodeOverlays(context, map);
        if (map.isFullScreen()) {
            this.encodeFullScreen(context, map);
        }
        if (map.getOnPointClick() != null) {
            wb.callback("onPointClick", "function(event)", map.getOnPointClick() + ";");
        }
        this.encodeClientBehaviors(context, map);
        wb.finish();
    }

    protected void encodeFullScreen(FacesContext context, OSMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",fullScreen: " + map.isFullScreen());
    }

    protected void encodeOverlays(FacesContext context, OSMap map) throws IOException {
        MapModel model = map.getModel();
        if (model != null) {
            if (!model.getMarkers().isEmpty()) {
                this.encodeMarkers(context, map);
            }
            if (!model.getPolylines().isEmpty()) {
                this.encodePolylines(context, map);
            }
            if (!model.getPolygons().isEmpty()) {
                this.encodePolygons(context, map);
            }
            if (!model.getCircles().isEmpty()) {
                this.encodeCircles(context, map);
            }
            if (!model.getRectangles().isEmpty()) {
                this.encodeRectangles(context, map);
            }
        }
    }

    protected void encodeMarkers(FacesContext context, OSMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",markers:[");
        Iterator iterator = model.getMarkers().iterator();
        while (iterator.hasNext()) {
            Marker marker = (Marker)iterator.next();
            this.encodeMarker(context, marker);
            if (!iterator.hasNext()) continue;
            writer.write(",\n");
        }
        writer.write("]");
    }

    protected void encodeMarker(FacesContext context, Marker marker) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("L.marker([");
        writer.write(marker.getLatlng().getLat() + ", " + marker.getLatlng().getLng() + "]");
        writer.write(", {customId:'" + marker.getId() + "'");
        if (marker.getIcon() != null) {
            writer.write(", icon:");
            this.encodeIcon(context, marker.getIcon());
        }
        if (marker.isDraggable()) {
            writer.write(",draggable: true");
        }
        writer.write("})");
    }

    protected void encodeIcon(FacesContext context, Object icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (!(icon instanceof String)) {
            throw new FacesException("OSMap marker icon must be String");
        }
        writer.write("'" + String.valueOf(icon) + "'");
    }

    protected void encodePolylines(FacesContext context, OSMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",polylines:[");
        Iterator lines = model.getPolylines().iterator();
        while (lines.hasNext()) {
            Polyline polyline = (Polyline)lines.next();
            writer.write("L.polyline([");
            this.encodePaths(context, polyline.getPaths());
            writer.write("], {customId:'" + polyline.getId() + "'");
            writer.write(",opacity:" + polyline.getStrokeOpacity());
            writer.write(",weight:" + polyline.getStrokeWeight());
            if (polyline.getStrokeColor() != null) {
                writer.write(",color:'" + polyline.getStrokeColor() + "'");
            }
            writer.write("})");
            if (!lines.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodePolygons(FacesContext context, OSMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",polygons:[");
        Iterator polygons = model.getPolygons().iterator();
        while (polygons.hasNext()) {
            Polygon polygon = (Polygon)polygons.next();
            writer.write("L.polygon([");
            this.encodePaths(context, polygon.getPaths());
            writer.write("], {customId:'" + polygon.getId() + "'");
            writer.write(",opacity:" + polygon.getStrokeOpacity());
            writer.write(",weight:" + polygon.getStrokeWeight());
            writer.write(",fillOpacity:" + polygon.getFillOpacity());
            if (polygon.getStrokeColor() != null) {
                writer.write(",color:'" + polygon.getStrokeColor() + "'");
            }
            if (polygon.getFillColor() != null) {
                writer.write(",fillColor:'" + polygon.getFillColor() + "'");
            }
            writer.write("})");
            if (!polygons.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodeCircles(FacesContext context, OSMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",circles:[");
        Iterator circles = model.getCircles().iterator();
        while (circles.hasNext()) {
            Circle circle = (Circle)circles.next();
            writer.write("L.circle([");
            writer.write(circle.getCenter().getLat() + ", " + circle.getCenter().getLng() + "]");
            writer.write(", {customId:'" + circle.getId() + "'");
            writer.write(",radius:" + circle.getRadius());
            writer.write(",opacity:" + circle.getStrokeOpacity());
            writer.write(",weight:" + circle.getStrokeWeight());
            writer.write(",fillOpacity:" + circle.getFillOpacity());
            if (circle.getStrokeColor() != null) {
                writer.write(",color:'" + circle.getStrokeColor() + "'");
            }
            if (circle.getFillColor() != null) {
                writer.write(",fillColor:'" + circle.getFillColor() + "'");
            }
            writer.write("})");
            if (!circles.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodeRectangles(FacesContext context, OSMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",rectangles:[");
        Iterator rectangles = model.getRectangles().iterator();
        while (rectangles.hasNext()) {
            Rectangle rectangle = (Rectangle)rectangles.next();
            LatLng ne = rectangle.getBounds().getNorthEast();
            LatLng sw = rectangle.getBounds().getSouthWest();
            writer.write("L.rectangle([");
            writer.write("[" + sw.getLat() + ", " + sw.getLng() + "],[" + ne.getLat() + ", " + ne.getLng() + "]");
            writer.write("]");
            writer.write(", {customId:'" + rectangle.getId() + "'");
            writer.write(",opacity:" + rectangle.getStrokeOpacity());
            writer.write(",weight:" + rectangle.getStrokeWeight());
            writer.write(",fillOpacity:" + rectangle.getFillOpacity());
            if (rectangle.getStrokeColor() != null) {
                writer.write(",color:'" + rectangle.getStrokeColor() + "'");
            }
            if (rectangle.getFillColor() != null) {
                writer.write(",fillColor:'" + rectangle.getFillColor() + "'");
            }
            writer.write("})");
            if (!rectangles.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodePaths(FacesContext context, List<LatLng> paths) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator<LatLng> coords = paths.iterator();
        while (coords.hasNext()) {
            LatLng coord = coords.next();
            writer.write("[" + coord.getLat() + ", " + coord.getLng() + "]");
            if (!coords.hasNext()) continue;
            writer.write(",");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

