/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.cookiepolicy;

import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.extensions.component.cookiepolicy.CookiePolicy;
import org.primefaces.util.LangUtils;
import org.primefaces.util.ResourceUtils;

public class CookiePolicySaveActionListener
implements ActionListener,
StateHolder {
    private ValueExpression policyValueExpression;
    private ValueExpression retentionValueExpression;
    private boolean _transient;

    public CookiePolicySaveActionListener() {
    }

    public CookiePolicySaveActionListener(ValueExpression policyValueExpression, ValueExpression retentionValueExpression) {
        this();
        this.policyValueExpression = policyValueExpression;
        this.retentionValueExpression = retentionValueExpression;
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return new Object[]{this.policyValueExpression, this.retentionValueExpression};
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] stateObjects = (Object[])state;
        if (stateObjects.length == 0) {
            return;
        }
        this.policyValueExpression = (ValueExpression)stateObjects[0];
        this.retentionValueExpression = (ValueExpression)stateObjects[1];
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        String policy = (String)this.policyValueExpression.getValue(elContext);
        Integer retention = null != this.retentionValueExpression ? (Integer)this.retentionValueExpression.getValue(elContext) : Integer.valueOf(10);
        HashMap<String, Object> cookieOptions = new HashMap<String, Object>(6);
        String path = externalContext.getRequestContextPath();
        cookieOptions.put("path", LangUtils.isBlank((String)path) ? "/" : path);
        cookieOptions.put("maxAge", retention);
        cookieOptions.put("httpOnly", Boolean.TRUE);
        ResourceUtils.addResponseCookie((FacesContext)facesContext, (String)"CookiePolicy", (String)policy, cookieOptions);
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        httpServletRequest.setAttribute(CookiePolicy.COOKIE_POLICY_REQUEST_ATTRIBUTE, (Object)policy);
    }
}

