/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.application;

import java.util.Objects;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlBody;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.primefaces.component.outputlabel.OutputLabel;
import org.primefaces.extensions.util.HtmlSanitizer;

public class EscapeSanitizerComponentListener
implements SystemEventListener {
    private static final String PASS_THROUGH_SANITIZED = "sanitized";

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = event.getFacesContext();
        UIViewRoot root = context.getViewRoot();
        this.checkComponents((UIComponent)root);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof HtmlBody;
    }

    private void checkComponents(UIComponent component) {
        String sanitizedValue;
        OutputLabel outputLabel;
        if (component == null) {
            return;
        }
        boolean shouldSanitize = false;
        String value = null;
        if (component instanceof HtmlOutputText) {
            HtmlOutputText htmlOutputText = (HtmlOutputText)component;
            if (!htmlOutputText.isEscape() && this.isNotAlreadySanitized(component)) {
                value = this.getValueAsString((UIComponent)htmlOutputText);
                shouldSanitize = value != null;
            }
        } else if (component instanceof OutputLabel && !(outputLabel = (OutputLabel)component).isEscape() && this.isNotAlreadySanitized(component)) {
            value = this.getValueAsString((UIComponent)outputLabel);
            boolean bl = shouldSanitize = value != null;
        }
        if (shouldSanitize && !Objects.equals(sanitizedValue = this.sanitizeHtml(value), value)) {
            component.getAttributes().put("value", this.sanitizeHtml(value));
        }
        for (UIComponent child : component.getChildren()) {
            this.checkComponents(child);
        }
        for (UIComponent facet : component.getFacets().values()) {
            this.checkComponents(facet);
        }
    }

    private String sanitizeHtml(String html) {
        return HtmlSanitizer.sanitizeHtml(html, true, true, true, true, false, false, false);
    }

    private String getValueAsString(UIComponent component) {
        Object value = component.getAttributes().get("value");
        return value instanceof String ? (String)value : null;
    }

    private boolean isNotAlreadySanitized(UIComponent component) {
        return !"true".equals(component.getPassThroughAttributes().get(PASS_THROUGH_SANITIZED));
    }
}

