
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Control the behavior and rendering of the inline hints.
 */
@SuppressWarnings("serial")
public class EditorInlineEditOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorInlineEditOptions(this);
    }

    private static class SerializedEditorInlineEditOptions implements Serializable {
        private String json;

        public SerializedEditorInlineEditOptions(EditorInlineEditOptions editorInlineEditOptions) {
            this.json = editorInlineEditOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorInlineEditOptions editorInlineEditOptions = new EditorInlineEditOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorInlineEditOptions.put(key, value);
            }
            return editorInlineEditOptions;
        }
    }

    /**
     * @return Enable or disable the rendering of automatic inline edit.
     */
    public Boolean isEnabled() {
        return (Boolean) (has("enabled") ? get("enabled") : null);
    }

    /**
     * @param enabled Enable or disable the rendering of automatic inline edit.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineEditOptions setEnabled(final Boolean enabled) {
        put("enabled", enabled);
        return this;
    }

    /**
     * @return Font family for inline suggestions.
     */
    public String getFontFamily() {
        return (String) (has("fontFamily") ? get("fontFamily") : null);
    }

    /**
     * @param fontFamily Font family for inline suggestions.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineEditOptions setFontFamily(final String fontFamily) {
        put("fontFamily", fontFamily);
        return this;
    }

    /**
     * @return Does not clear active inline suggestions when the editor loses focus.
     */
    public Boolean isKeepOnBlur() {
        return (Boolean) (has("keepOnBlur") ? get("keepOnBlur") : null);
    }

    /**
     * @param keepOnBlur Does not clear active inline suggestions when the editor loses focus.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorInlineEditOptions setKeepOnBlur(final Boolean keepOnBlur) {
        put("keepOnBlur", keepOnBlur);
        return this;
    }

    public String getShowToolbar() {
        return (String) (has("showToolbar") ? get("showToolbar") : null);
    }

    public EditorInlineEditOptions setShowToolbar(final EInlineEditorShowToolbarMode showToolbar) {
        put("showToolbar", showToolbar != null ? showToolbar.toString() : null);
        return this;
    }

    public EditorInlineEditOptions setShowToolbar(final String showToolbar) {
        put("showToolbar", showToolbar);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}