
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Configuration options for go to location
 */
@SuppressWarnings("serial")
public class EditorGotoLocationOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorGotoLocationOptions(this);
    }

    private static class SerializedEditorGotoLocationOptions implements Serializable {
        private String json;

        public SerializedEditorGotoLocationOptions(EditorGotoLocationOptions editorGotoLocationOptions) {
            this.json = editorGotoLocationOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorGotoLocationOptions editorGotoLocationOptions = new EditorGotoLocationOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorGotoLocationOptions.put(key, value);
            }
            return editorGotoLocationOptions;
        }
    }

    public String getAlternativeDeclarationCommand() {
        return (String) (has("alternativeDeclarationCommand") ? get("alternativeDeclarationCommand") : null);
    }

    public EditorGotoLocationOptions setAlternativeDeclarationCommand(final String alternativeDeclarationCommand) {
        put("alternativeDeclarationCommand", alternativeDeclarationCommand);
        return this;
    }

    public String getAlternativeDefinitionCommand() {
        return (String) (has("alternativeDefinitionCommand") ? get("alternativeDefinitionCommand") : null);
    }

    public EditorGotoLocationOptions setAlternativeDefinitionCommand(final String alternativeDefinitionCommand) {
        put("alternativeDefinitionCommand", alternativeDefinitionCommand);
        return this;
    }

    public String getAlternativeImplementationCommand() {
        return (String) (has("alternativeImplementationCommand") ? get("alternativeImplementationCommand") : null);
    }

    public EditorGotoLocationOptions setAlternativeImplementationCommand(final String alternativeImplementationCommand) {
        put("alternativeImplementationCommand", alternativeImplementationCommand);
        return this;
    }

    public String getAlternativeReferenceCommand() {
        return (String) (has("alternativeReferenceCommand") ? get("alternativeReferenceCommand") : null);
    }

    public EditorGotoLocationOptions setAlternativeReferenceCommand(final String alternativeReferenceCommand) {
        put("alternativeReferenceCommand", alternativeReferenceCommand);
        return this;
    }

    public String getAlternativeTestsCommand() {
        return (String) (has("alternativeTestsCommand") ? get("alternativeTestsCommand") : null);
    }

    public EditorGotoLocationOptions setAlternativeTestsCommand(final String alternativeTestsCommand) {
        put("alternativeTestsCommand", alternativeTestsCommand);
        return this;
    }

    public String getAlternativeTypeDefinitionCommand() {
        return (String) (has("alternativeTypeDefinitionCommand") ? get("alternativeTypeDefinitionCommand") : null);
    }

    public EditorGotoLocationOptions setAlternativeTypeDefinitionCommand(final String alternativeTypeDefinitionCommand) {
        put("alternativeTypeDefinitionCommand", alternativeTypeDefinitionCommand);
        return this;
    }

    public String getMultiple() {
        return (String) (has("multiple") ? get("multiple") : null);
    }

    public EditorGotoLocationOptions setMultiple(final EGoToLocationValues multiple) {
        put("multiple", multiple != null ? multiple.toString() : null);
        return this;
    }

    public EditorGotoLocationOptions setMultiple(final String multiple) {
        put("multiple", multiple);
        return this;
    }

    public String getMultipleDeclarations() {
        return (String) (has("multipleDeclarations") ? get("multipleDeclarations") : null);
    }

    public EditorGotoLocationOptions setMultipleDeclarations(final EGoToLocationValues multipleDeclarations) {
        put("multipleDeclarations", multipleDeclarations != null ? multipleDeclarations.toString() : null);
        return this;
    }

    public EditorGotoLocationOptions setMultipleDeclarations(final String multipleDeclarations) {
        put("multipleDeclarations", multipleDeclarations);
        return this;
    }

    public String getMultipleDefinitions() {
        return (String) (has("multipleDefinitions") ? get("multipleDefinitions") : null);
    }

    public EditorGotoLocationOptions setMultipleDefinitions(final EGoToLocationValues multipleDefinitions) {
        put("multipleDefinitions", multipleDefinitions != null ? multipleDefinitions.toString() : null);
        return this;
    }

    public EditorGotoLocationOptions setMultipleDefinitions(final String multipleDefinitions) {
        put("multipleDefinitions", multipleDefinitions);
        return this;
    }

    public String getMultipleImplementations() {
        return (String) (has("multipleImplementations") ? get("multipleImplementations") : null);
    }

    public EditorGotoLocationOptions setMultipleImplementations(final EGoToLocationValues multipleImplementations) {
        put("multipleImplementations", multipleImplementations != null ? multipleImplementations.toString() : null);
        return this;
    }

    public EditorGotoLocationOptions setMultipleImplementations(final String multipleImplementations) {
        put("multipleImplementations", multipleImplementations);
        return this;
    }

    public String getMultipleReferences() {
        return (String) (has("multipleReferences") ? get("multipleReferences") : null);
    }

    public EditorGotoLocationOptions setMultipleReferences(final EGoToLocationValues multipleReferences) {
        put("multipleReferences", multipleReferences != null ? multipleReferences.toString() : null);
        return this;
    }

    public EditorGotoLocationOptions setMultipleReferences(final String multipleReferences) {
        put("multipleReferences", multipleReferences);
        return this;
    }

    public String getMultipleTests() {
        return (String) (has("multipleTests") ? get("multipleTests") : null);
    }

    public EditorGotoLocationOptions setMultipleTests(final EGoToLocationValues multipleTests) {
        put("multipleTests", multipleTests != null ? multipleTests.toString() : null);
        return this;
    }

    public EditorGotoLocationOptions setMultipleTests(final String multipleTests) {
        put("multipleTests", multipleTests);
        return this;
    }

    public String getMultipleTypeDefinitions() {
        return (String) (has("multipleTypeDefinitions") ? get("multipleTypeDefinitions") : null);
    }

    public EditorGotoLocationOptions setMultipleTypeDefinitions(final EGoToLocationValues multipleTypeDefinitions) {
        put("multipleTypeDefinitions", multipleTypeDefinitions != null ? multipleTypeDefinitions.toString() : null);
        return this;
    }

    public EditorGotoLocationOptions setMultipleTypeDefinitions(final String multipleTypeDefinitions) {
        put("multipleTypeDefinitions", multipleTypeDefinitions);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}