
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * The initial editor dimension (to avoid measuring the container).
 */
@SuppressWarnings("serial")
public class EditorDimension extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorDimension(this);
    }

    private static class SerializedEditorDimension implements Serializable {
        private String json;

        public SerializedEditorDimension(EditorDimension editorDimension) {
            this.json = editorDimension.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorDimension editorDimension = new EditorDimension();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorDimension.put(key, value);
            }
            return editorDimension;
        }
    }

    public Number getHeight() {
        return (Number) (has("height") ? get("height") : null);
    }

    public EditorDimension setHeight(final Number height) {
        put("height", height);
        return this;
    }

    public Number getWidth() {
        return (Number) (has("width") ? get("width") : null);
    }

    public EditorDimension setWidth(final Number width) {
        put("width", width);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}