/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.converter;

import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Type;
import org.primefaces.extensions.converter.JsonConverter;
import org.primefaces.extensions.util.json.GsonConverter;
import org.primefaces.extensions.util.json.GsonExposeAwareConverter;

public class JsonExposeAwareConverter
extends JsonConverter {
    private static final long serialVersionUID = 1L;
    private boolean excludeFieldsWithoutExposeAnnotation = false;

    public JsonExposeAwareConverter() {
    }

    public JsonExposeAwareConverter(boolean excludeFieldsWithoutExposeAnnotation) {
        this.excludeFieldsWithoutExposeAnnotation = excludeFieldsWithoutExposeAnnotation;
    }

    public boolean isExcludeFieldsWithoutExposeAnnotation() {
        return this.excludeFieldsWithoutExposeAnnotation;
    }

    public void setExcludeFieldsWithoutExposeAnnotation(boolean excludeFieldsWithoutExposeAnnotation) {
        this.excludeFieldsWithoutExposeAnnotation = excludeFieldsWithoutExposeAnnotation;
    }

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        Type objType;
        if (this.getType() == null) {
            ValueExpression expression = component.getValueExpression("value");
            objType = expression.getType(context.getELContext());
        } else {
            objType = this.getObjectType(this.getType().trim(), false);
        }
        if (this.excludeFieldsWithoutExposeAnnotation) {
            return GsonExposeAwareConverter.getGson().fromJson(value, objType);
        }
        return GsonConverter.getGson().fromJson(value, objType);
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (this.excludeFieldsWithoutExposeAnnotation) {
            if (this.getType() == null) {
                return GsonExposeAwareConverter.getGson().toJson(value);
            }
            return GsonExposeAwareConverter.getGson().toJson(value, this.getObjectType(this.getType().trim(), false));
        }
        if (this.getType() == null) {
            return GsonConverter.getGson().toJson(value);
        }
        return GsonConverter.getGson().toJson(value, this.getObjectType(this.getType().trim(), false));
    }
}

