
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Configuration options for editor minimap
 */
@SuppressWarnings("serial")
public class EditorMinimapOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorMinimapOptions(this);
    }

    private static class SerializedEditorMinimapOptions implements Serializable {
        private String json;

        public SerializedEditorMinimapOptions(EditorMinimapOptions editorMinimapOptions) {
            this.json = editorMinimapOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorMinimapOptions editorMinimapOptions = new EditorMinimapOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorMinimapOptions.put(key, value);
            }
            return editorMinimapOptions;
        }
    }

    /**
     * @return Control the rendering of minimap.
     */
    public Boolean isAutohide() {
        return (Boolean) (has("autohide") ? get("autohide") : null);
    }

    /**
     * @param autohide Control the rendering of minimap.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setAutohide(final Boolean autohide) {
        put("autohide", autohide);
        return this;
    }

    /**
     * @return Enable the rendering of the minimap. Defaults to {@code true}.
     */
    public Boolean isEnabled() {
        return (Boolean) (has("enabled") ? get("enabled") : null);
    }

    /**
     * @param enabled Enable the rendering of the minimap. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setEnabled(final Boolean enabled) {
        put("enabled", enabled);
        return this;
    }

    /**
     * @return Limit the width of the minimap to render at most a certain number of columns. Defaults to {@code 120}.
     */
    public Number getMaxColumn() {
        return (Number) (has("maxColumn") ? get("maxColumn") : null);
    }

    /**
     * @param maxColumn Limit the width of the minimap to render at most a certain number of columns. Defaults to {@code
     * 120}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setMaxColumn(final Number maxColumn) {
        put("maxColumn", maxColumn);
        return this;
    }

    /**
     * @return Render the actual text on a line (as opposed to color blocks). Defaults to {@code true}.
     */
    public Boolean isRenderCharacters() {
        return (Boolean) (has("renderCharacters") ? get("renderCharacters") : null);
    }

    /**
     * @param renderCharacters Render the actual text on a line (as opposed to color blocks). Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setRenderCharacters(final Boolean renderCharacters) {
        put("renderCharacters", renderCharacters);
        return this;
    }

    /**
     * @return Relative size of the font in the minimap. Defaults to {@code 1}.
     */
    public Number getScale() {
        return (Number) (has("scale") ? get("scale") : null);
    }

    /**
     * @param scale Relative size of the font in the minimap. Defaults to {@code 1}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setScale(final Number scale) {
        put("scale", scale);
        return this;
    }

    /**
     * @return Font size of section headers. Defaults to {@code 9}.
     */
    public Number getSectionHeaderFontSize() {
        return (Number) (has("sectionHeaderFontSize") ? get("sectionHeaderFontSize") : null);
    }

    /**
     * @param sectionHeaderFontSize Font size of section headers. Defaults to {@code 9}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setSectionHeaderFontSize(final Number sectionHeaderFontSize) {
        put("sectionHeaderFontSize", sectionHeaderFontSize);
        return this;
    }

    /**
     * @return Spacing between the section header characters (in CSS px). Defaults to {@code 1}.
     */
    public Number getSectionHeaderLetterSpacing() {
        return (Number) (has("sectionHeaderLetterSpacing") ? get("sectionHeaderLetterSpacing") : null);
    }

    /**
     * @param sectionHeaderLetterSpacing Spacing between the section header characters (in CSS px). Defaults to {@code
     * 1}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setSectionHeaderLetterSpacing(final Number sectionHeaderLetterSpacing) {
        put("sectionHeaderLetterSpacing", sectionHeaderLetterSpacing);
        return this;
    }

    /**
     * @return Whether to show MARK: comments as section headers. Defaults to {@code true}.
     */
    public Boolean isShowMarkSectionHeaders() {
        return (Boolean) (has("showMarkSectionHeaders") ? get("showMarkSectionHeaders") : null);
    }

    /**
     * @param showMarkSectionHeaders Whether to show MARK: comments as section headers. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setShowMarkSectionHeaders(final Boolean showMarkSectionHeaders) {
        put("showMarkSectionHeaders", showMarkSectionHeaders);
        return this;
    }

    /**
     * @return Whether to show named regions as section headers. Defaults to {@code true}.
     */
    public Boolean isShowRegionSectionHeaders() {
        return (Boolean) (has("showRegionSectionHeaders") ? get("showRegionSectionHeaders") : null);
    }

    /**
     * @param showRegionSectionHeaders Whether to show named regions as section headers. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setShowRegionSectionHeaders(final Boolean showRegionSectionHeaders) {
        put("showRegionSectionHeaders", showRegionSectionHeaders);
        return this;
    }

    /**
     * @return Control the rendering of the minimap slider. Defaults to {@code mouseover}.
     */
    public String getShowSlider() {
        return (String) (has("showSlider") ? get("showSlider") : null);
    }

    /**
     * @param showSlider Control the rendering of the minimap slider. Defaults to {@code mouseover}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setShowSlider(final EMinimapShowSlider showSlider) {
        put("showSlider", showSlider != null ? showSlider.toString() : null);
        return this;
    }

    /**
     * @param showSlider Control the rendering of the minimap slider. Defaults to {@code mouseover}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setShowSlider(final String showSlider) {
        put("showSlider", showSlider);
        return this;
    }

    /**
     * @return Control the side of the minimap in editor. Defaults to {@code right}.
     */
    public String getSide() {
        return (String) (has("side") ? get("side") : null);
    }

    /**
     * @param side Control the side of the minimap in editor. Defaults to {@code right}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setSide(final EMinimapSide side) {
        put("side", side != null ? side.toString() : null);
        return this;
    }

    /**
     * @param side Control the side of the minimap in editor. Defaults to {@code right}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setSide(final String side) {
        put("side", side);
        return this;
    }

    /**
     * @return Control the minimap rendering mode. Defaults to actual.
     */
    public String getSize() {
        return (String) (has("size") ? get("size") : null);
    }

    /**
     * @param size Control the minimap rendering mode. Defaults to actual.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setSize(final EMinimapSize size) {
        put("size", size != null ? size.toString() : null);
        return this;
    }

    /**
     * @param size Control the minimap rendering mode. Defaults to actual.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorMinimapOptions setSize(final String size) {
        put("size", size);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}