/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.slideout;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.extensions.component.slideout.SlideOut;
import org.primefaces.extensions.util.ExtLangUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SlideOutRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SlideOut slideOut = (SlideOut)component;
        this.encodeMarkup(context, slideOut);
        this.encodeScript(context, slideOut);
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeMarkup(FacesContext context, SlideOut slideOut) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = slideOut.getClientId(context);
        String widgetVar = slideOut.resolveWidgetVar();
        writer.startElement("div", (UIComponent)slideOut);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        if (slideOut.getPanelStyleClass() != null) {
            writer.writeAttribute("class", (Object)slideOut.getPanelStyleClass(), "styleClass");
        }
        if (slideOut.getPanelStyle() != null) {
            writer.writeAttribute("style", (Object)slideOut.getPanelStyle(), "style");
        }
        this.encodeHandle(context, slideOut);
        this.renderChildren(context, (UIComponent)slideOut);
        writer.endElement("div");
    }

    private void encodeHandle(FacesContext context, SlideOut slideOut) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-slideout-handle ui-slideouttab-handle-rounded").add(slideOut.getHandleStyleClass()).build();
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)this.getHandleId(context, slideOut), null);
        if (slideOut.getHandleStyle() != null) {
            writer.writeAttribute("style", (Object)slideOut.getHandleStyle(), "style");
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        this.encodeIcon(context, slideOut);
        if (slideOut.getTitle() != null) {
            writer.writeText((Object)slideOut.getTitle(), "title");
        }
        writer.endElement("a");
    }

    private void encodeIcon(FacesContext context, SlideOut slideOut) throws IOException {
        if (slideOut.getIcon() == null) {
            return;
        }
        String icon = slideOut.getIcon().trim();
        if (icon.startsWith("ui")) {
            icon = "ui-icon " + icon + " ui-slideouttab-icon";
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)icon, null);
        writer.endElement("span");
        writer.write(" ");
    }

    private void encodeScript(FacesContext context, SlideOut slideOut) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        String handleId = this.getHandleId(context, slideOut);
        wb.init("ExtSlideOut", (UIComponent)slideOut);
        wb.attr("tabLocation", slideOut.getLocation());
        wb.attr("tabHandle", handleId);
        wb.attr("speed", (Number)slideOut.getAnimateSpeed());
        wb.attr("action", ExtLangUtils.lowerCase(slideOut.getShowOn()));
        wb.attr("clickScreenToClose", Boolean.valueOf(slideOut.isClickScreenToClose()));
        wb.attr("onLoadSlideOut", Boolean.valueOf(slideOut.isAutoOpen()));
        wb.attr("positioning", slideOut.isSticky() ? "absolute" : "fixed");
        wb.attr("offset", slideOut.getOffset());
        wb.attr("offsetReverse", Boolean.valueOf(slideOut.isOffsetReverse()));
        wb.attr("handleOffsetReverse", Boolean.valueOf(slideOut.isHandleOffsetReverse()));
        wb.attr("bounceTimes", (Number)slideOut.getBounceTimes());
        wb.attr("bounceDistance", slideOut.getBounceDistance());
        wb.nativeAttr("clickScreenToCloseFilters", "['.ui-slideouttab-panel', 'button', 'a']");
        if (slideOut.getHandleOffset() != null) {
            wb.attr("handleOffset", slideOut.getHandleOffset());
        }
        if (slideOut.getOnopen() != null) {
            wb.callback("onOpen", "function()", slideOut.getOnopen());
        }
        if (slideOut.getOnclose() != null) {
            wb.callback("onClose", "function()", slideOut.getOnclose());
        }
        if (slideOut.getOnslide() != null) {
            wb.callback("onSlide", "function()", slideOut.getOnslide());
        }
        if (slideOut.getOnbeforeopen() != null) {
            wb.callback("onBeforeOpen", "function()", slideOut.getOnbeforeopen());
        }
        if (slideOut.getOnbeforeclose() != null) {
            wb.callback("onBeforeClose", "function()", slideOut.getOnbeforeclose());
        }
        if (slideOut.getOnbeforeslide() != null) {
            wb.callback("onBeforeSlide", "function()", slideOut.getOnbeforeslide());
        }
        this.encodeClientBehaviors(context, slideOut);
        wb.finish();
    }

    private String getHandleId(FacesContext context, SlideOut slideOut) {
        String clientId = slideOut.getClientId(context);
        return clientId + "_handle";
    }
}

