/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.masterdetail;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UniqueIdVendor;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import org.primefaces.extensions.component.masterdetail.MasterDetail;
import org.primefaces.extensions.component.masterdetail.MasterDetailLevel;
import org.primefaces.util.ComponentTraversalUtils;

public class PreRenderSourceListener
implements ComponentSystemEventListener,
Serializable {
    private static final long serialVersionUID = 20111121L;

    public void processEvent(ComponentSystemEvent event) {
        Object contextValue;
        Object resetInputs;
        Object preserveInputs;
        Object selectedStep;
        Object selectedLevel;
        UIComponent source = event.getComponent();
        MasterDetail masterDetail = this.findMasterDetail(source);
        if (masterDetail == null) {
            throw new FacesException("MasterDetail was not found. SelectDetailLevel can be only used inside of MasterDetail.");
        }
        MasterDetailLevel masterDetailLevel = this.findMasterDetailLevel(source);
        if (masterDetailLevel == null) {
            throw new FacesException("MasterDetailLevel was not found. SelectDetailLevel can be only used inside of MasterDetailLevel.");
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        String masterDetailClientId = masterDetail.getClientId(fc);
        this.addUIParameter(fc, source, masterDetailClientId + "_selectDetailRequest", true);
        this.addUIParameter(fc, source, masterDetailClientId + "_currentLevel", masterDetailLevel.getLevel());
        ValueExpression selectedLevelVE = (ValueExpression)source.getAttributes().get("selectedLevelVE");
        Object object = selectedLevel = selectedLevelVE != null ? selectedLevelVE.getValue(fc.getELContext()) : null;
        if (selectedLevel != null) {
            this.addUIParameter(fc, source, masterDetailClientId + "_selectedLevel", selectedLevel);
        } else {
            this.removeUIParameter(source, masterDetailClientId + "_selectedLevel");
        }
        ValueExpression selectedStepVE = (ValueExpression)source.getAttributes().get("selectedStepVE");
        Object object2 = selectedStep = selectedStepVE != null ? selectedStepVE.getValue(fc.getELContext()) : null;
        if (selectedStep != null) {
            this.addUIParameter(fc, source, masterDetailClientId + "_selectedStep", selectedStep);
        } else {
            this.removeUIParameter(source, masterDetailClientId + "_selectedStep");
        }
        ValueExpression preserveInputsVE = (ValueExpression)source.getAttributes().get("preserveInputsVE");
        Object object3 = preserveInputs = preserveInputsVE != null ? preserveInputsVE.getValue(fc.getELContext()) : null;
        if (preserveInputs != null) {
            this.addUIParameter(fc, source, masterDetailClientId + "_preserveInputs", preserveInputs);
        } else {
            this.removeUIParameter(source, masterDetailClientId + "_preserveInputs");
        }
        ValueExpression resetInputsVE = (ValueExpression)source.getAttributes().get("resetInputsVE");
        Object object4 = resetInputs = resetInputsVE != null ? resetInputsVE.getValue(fc.getELContext()) : null;
        if (resetInputs != null) {
            this.addUIParameter(fc, source, masterDetailClientId + "_resetInputs", resetInputs);
        } else {
            this.removeUIParameter(source, masterDetailClientId + "_resetInputs");
        }
        ValueExpression contextValueVE = (ValueExpression)source.getAttributes().get("mdContextValueVE");
        if (contextValueVE == null) {
            return;
        }
        HashMap<String, Object> contextValues = (HashMap<String, Object>)masterDetailLevel.getAttributes().get("mdContextValues");
        if (contextValues == null) {
            contextValues = new HashMap<String, Object>();
        }
        if ((contextValue = contextValueVE.getValue(fc.getELContext())) != null) {
            contextValues.put("contextValue_" + source.getClientId(fc), contextValue);
        } else {
            contextValues.remove("contextValue_" + source.getClientId(fc));
        }
        masterDetailLevel.getAttributes().put("mdContextValues", contextValues);
    }

    private MasterDetail findMasterDetail(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MasterDetail)) continue;
            return (MasterDetail)parent;
        }
        return null;
    }

    private MasterDetailLevel findMasterDetailLevel(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MasterDetailLevel)) continue;
            return (MasterDetailLevel)parent;
        }
        return null;
    }

    private void addUIParameter(FacesContext fc, UIComponent source, String paramName, Object paramValue) {
        for (UIComponent child : source.getChildren()) {
            if (!(child instanceof UIParameter) || !paramName.equals(((UIParameter)child).getName())) continue;
            ((UIParameter)child).setValue(paramValue);
            return;
        }
        UIParameter uiParameter = new UIParameter();
        uiParameter.setId(this.createUniqueId(fc, source));
        uiParameter.setName(paramName);
        uiParameter.setValue(paramValue);
        uiParameter.setTransient(true);
        source.getChildren().add(uiParameter);
    }

    private void removeUIParameter(UIComponent source, String paramName) {
        List childs = source.getChildren();
        if (childs == null || childs.isEmpty()) {
            return;
        }
        for (UIComponent child : childs) {
            if (!(child instanceof UIParameter) || !paramName.equals(((UIParameter)child).getName())) continue;
            childs.remove(child);
            break;
        }
    }

    private String createUniqueId(FacesContext fc, UIComponent source) {
        UniqueIdVendor parentUniqueIdVendor = ComponentTraversalUtils.closestUniqueIdVendor((UIComponent)source);
        if (parentUniqueIdVendor == null) {
            UIViewRoot viewRoot = fc.getViewRoot();
            if (viewRoot != null) {
                return viewRoot.createUniqueId(fc, null);
            }
            throw new FacesException("Cannot create Id for UIParameter attached to " + source.getClass().getCanonicalName());
        }
        return parentUniqueIdVendor.createUniqueId(fc, null);
    }
}

