/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.behavior.ajax.AjaxBehavior;

public class ComponentUtils
extends org.primefaces.util.ComponentUtils {
    private ComponentUtils() {
    }

    public static String escapeComponentId(String id) {
        return id.replaceAll(":", "\\\\\\\\:");
    }

    @Deprecated
    public static void addComponentResource(FacesContext context, String name) {
        ComponentUtils.addComponentResource(context, name, "primefaces-extensions", "head");
    }

    @Deprecated
    public static void addComponentResource(FacesContext context, String name, String library, String target) {
        Application application = context.getApplication();
        UIComponent componentResource = application.createComponent("javax.faces.Output");
        componentResource.setRendererType(application.getResourceHandler().getRendererTypeForResourceName(name));
        componentResource.setTransient(true);
        componentResource.setId(context.getViewRoot().createUniqueId());
        componentResource.getAttributes().put("name", name);
        componentResource.getAttributes().put("library", library);
        componentResource.getAttributes().put("target", target);
        context.getViewRoot().addComponentResource(context, componentResource, target);
    }

    public static String escapeText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            ComponentUtils.escapeChar(sb, text.charAt(i));
        }
        return sb.toString();
    }

    @Deprecated
    public static char[] escapeText(char[] text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : text) {
            ComponentUtils.escapeChar(sb, c);
        }
        return sb.toString().toCharArray();
    }

    public static String escapeHtmlTextInJson(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            ComponentUtils.escapeHtmlCharInJson(sb, text.charAt(i));
        }
        return sb.toString();
    }

    public static char[] escapeHtmlTextInJson(char[] text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : text) {
            ComponentUtils.escapeHtmlCharInJson(sb, c);
        }
        return sb.toString().toCharArray();
    }

    private static void escapeChar(StringBuilder sb, char ch) {
        switch (ch) {
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '/': {
                sb.append("\\/");
                break;
            }
            default: {
                if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                    String ss = Integer.toHexString(ch);
                    sb.append("\\u");
                    for (int k = 0; k < 4 - ss.length(); ++k) {
                        sb.append('0');
                    }
                    sb.append(ss.toUpperCase());
                    break;
                }
                sb.append(ch);
            }
        }
    }

    private static void escapeHtmlCharInJson(StringBuilder sb, char ch) {
        switch (ch) {
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': {
                break;
            }
            default: {
                sb.append(ch);
            }
        }
    }

    public static Object getConvertedSubmittedValue(FacesContext fc, EditableValueHolder evh) {
        Object submittedValue = evh.getSubmittedValue();
        if (submittedValue == null) {
            return submittedValue;
        }
        try {
            Converter converter;
            UIComponent component = (UIComponent)evh;
            Renderer renderer = ComponentUtils.getRenderer(fc, component);
            if (renderer != null) {
                return renderer.getConvertedValue(fc, component, submittedValue);
            }
            if (submittedValue instanceof String && (converter = ComponentUtils.getConverter((FacesContext)fc, (UIComponent)component)) != null) {
                return converter.getAsObject(fc, component, (String)submittedValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return submittedValue;
    }

    public static Renderer getRenderer(FacesContext fc, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType != null) {
            return fc.getRenderKit().getRenderer(component.getFamily(), rendererType);
        }
        return null;
    }

    public static boolean isAjaxifiedComponent(UIComponent component) {
        Collection behaviors;
        if (component instanceof AjaxSource && ((AjaxSource)component).isAjaxified()) {
            return true;
        }
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors().values()).isEmpty()) {
            for (List listBehaviors : behaviors) {
                for (ClientBehavior clientBehavior : listBehaviors) {
                    if (!(clientBehavior instanceof javax.faces.component.behavior.AjaxBehavior) && !(clientBehavior instanceof AjaxBehavior)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    public static String escapeSelector(String value) {
        StringBuilder builder = new StringBuilder();
        block4: for (char c : value.toCharArray()) {
            switch (c) {
                case '\\': {
                    builder.append("\\\\\\\\");
                    continue block4;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '>': 
                case '[': 
                case ']': 
                case '^': 
                case '|': 
                case '~': {
                    builder.append("\\\\");
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    @Deprecated
    public static Locale resolveLocale(Object locale) {
        if (locale instanceof String) {
            locale = org.primefaces.util.ComponentUtils.toLocale((String)((String)locale));
        }
        if (locale == null) {
            locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        }
        return (Locale)locale;
    }

    public static TimeZone resolveTimeZone(Object timeZone) {
        if (timeZone instanceof String) {
            return TimeZone.getTimeZone((String)timeZone);
        }
        if (timeZone instanceof TimeZone) {
            return (TimeZone)timeZone;
        }
        return TimeZone.getDefault();
    }
}

