/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timeline;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.timeline.TimelineAddEvent;
import org.primefaces.extensions.event.timeline.TimelineDragDropEvent;
import org.primefaces.extensions.event.timeline.TimelineLazyLoadEvent;
import org.primefaces.extensions.event.timeline.TimelineModificationEvent;
import org.primefaces.extensions.event.timeline.TimelineRangeEvent;
import org.primefaces.extensions.event.timeline.TimelineSelectEvent;
import org.primefaces.extensions.model.timeline.TimelineEvent;
import org.primefaces.extensions.model.timeline.TimelineModel;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.extensions.util.DateUtils;
import org.primefaces.extensions.util.visitcallback.UIDataContextCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="primefaces.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.css"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="timeline/timeline.css"), @ResourceDependency(library="primefaces-extensions", name="timeline/timeline.js")})
public class Timeline
extends UIComponentBase
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Timeline";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.TimelineRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("add", "change", "edit", "delete", "select", "rangechange", "rangechanged", "lazyload", "drop"));

    public Timeline() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public TimelineModel getValue() {
        return (TimelineModel)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value), null);
    }

    public void setValue(TimelineModel value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), (Object)value);
    }

    public String getVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.var), null);
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)var);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.locale), locale);
    }

    public Object getTimeZone() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeZone), null);
    }

    public void setTimeZone(Object timeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.timeZone), timeZone);
    }

    public Object getBrowserTimeZone() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.browserTimeZone), null);
    }

    public void setBrowserTimeZone(Object timeZone) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.browserTimeZone), timeZone);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)styleClass);
    }

    public String getHeight() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.height), (Object)"auto");
    }

    public void setHeight(String height) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.height), (Object)height);
    }

    public int getMinHeight() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.minHeight), (Object)0);
    }

    public void setMinHeight(int minHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.minHeight), (Object)minHeight);
    }

    public String getWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.width), (Object)"100%");
    }

    public void setWidth(String width) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.width), (Object)width);
    }

    public boolean isResponsive() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.responsive), (Object)true);
    }

    public void setResponsive(boolean responsive) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.responsive), (Object)responsive);
    }

    public boolean isAxisOnTop() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.axisOnTop), (Object)false);
    }

    public void setAxisOnTop(boolean axisOnTop) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.axisOnTop), (Object)axisOnTop);
    }

    public int getDragAreaWidth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dragAreaWidth), (Object)10);
    }

    public void setDragAreaWidth(int dragAreaWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dragAreaWidth), (Object)dragAreaWidth);
    }

    public boolean isEditable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editable), (Object)false);
    }

    public void setEditable(boolean editable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editable), (Object)editable);
    }

    public boolean isSelectable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectable), (Object)true);
    }

    public void setSelectable(boolean selectable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectable), (Object)selectable);
    }

    public boolean isUnselectable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.unselectable), (Object)true);
    }

    public void setUnselectable(boolean unselectable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.unselectable), (Object)unselectable);
    }

    public boolean isZoomable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoomable), (Object)true);
    }

    public void setZoomable(boolean zoomable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoomable), (Object)zoomable);
    }

    public boolean isMoveable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.moveable), (Object)true);
    }

    public void setMoveable(boolean moveable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.moveable), (Object)moveable);
    }

    public Date getStart() {
        return (Date)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.start), null);
    }

    public void setStart(Date start) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.start), (Object)start);
    }

    public Date getEnd() {
        return (Date)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.end), null);
    }

    public void setEnd(Date end) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.end), (Object)end);
    }

    public Date getMin() {
        return (Date)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.min), null);
    }

    public void setMin(Date min) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.min), (Object)min);
    }

    public Date getMax() {
        return (Date)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.max), null);
    }

    public void setMax(Date max) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.max), (Object)max);
    }

    public long getZoomMin() {
        return (Long)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoomMin), (Object)10L);
    }

    public void setZoomMin(long zoomMin) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoomMin), (Object)zoomMin);
    }

    public long getZoomMax() {
        return (Long)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.zoomMax), (Object)315360000000000L);
    }

    public void setZoomMax(long zoomMax) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.zoomMax), (Object)zoomMax);
    }

    public float getPreloadFactor() {
        return ((Float)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.preloadFactor), (Object)Float.valueOf(0.0f))).floatValue();
    }

    public void setPreloadFactor(float preloadFactor) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.preloadFactor), (Object)Float.valueOf(preloadFactor));
    }

    public int getEventMargin() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.eventMargin), (Object)10);
    }

    public void setEventMargin(int eventMargin) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.eventMargin), (Object)eventMargin);
    }

    public int getEventMarginAxis() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.eventMarginAxis), (Object)10);
    }

    public void setEventMarginAxis(int eventMarginAxis) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.eventMarginAxis), (Object)eventMarginAxis);
    }

    public String getEventStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.eventStyle), (Object)"box");
    }

    public void setEventStyle(String eventStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.eventStyle), (Object)eventStyle);
    }

    public boolean isGroupsChangeable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.groupsChangeable), (Object)true);
    }

    public void setGroupsChangeable(boolean groupsChangeable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.groupsChangeable), (Object)groupsChangeable);
    }

    public boolean isGroupsOnRight() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.groupsOnRight), (Object)false);
    }

    public void setGroupsOnRight(boolean groupsOnRight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.groupsOnRight), (Object)groupsOnRight);
    }

    public String getGroupsWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.groupsWidth), null);
    }

    public void setGroupsWidth(String groupsWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.groupsWidth), (Object)groupsWidth);
    }

    public boolean isSnapEvents() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.snapEvents), (Object)true);
    }

    public void setSnapEvents(boolean snapEvents) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.snapEvents), (Object)snapEvents);
    }

    public boolean isStackEvents() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.stackEvents), (Object)true);
    }

    public void setStackEvents(boolean stackEvents) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.stackEvents), (Object)stackEvents);
    }

    public boolean isShowCurrentTime() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showCurrentTime), (Object)true);
    }

    public void setShowCurrentTime(boolean showCurrentTime) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showCurrentTime), (Object)showCurrentTime);
    }

    public boolean isShowMajorLabels() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMajorLabels), (Object)true);
    }

    public void setShowMajorLabels(boolean showMajorLabels) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showMajorLabels), (Object)showMajorLabels);
    }

    public boolean isShowMinorLabels() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMinorLabels), (Object)true);
    }

    public void setShowMinorLabels(boolean showMinorLabels) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showMinorLabels), (Object)showMinorLabels);
    }

    public boolean isShowButtonNew() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showButtonNew), (Object)false);
    }

    public void setShowButtonNew(boolean showButtonNew) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showButtonNew), (Object)showButtonNew);
    }

    public boolean isShowNavigation() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showNavigation), (Object)false);
    }

    public void setShowNavigation(boolean showNavigation) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.showNavigation), (Object)showNavigation);
    }

    public String getDropHoverStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropHoverStyleClass), null);
    }

    public void setDropHoverStyleClass(String dropHoverStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropHoverStyleClass), (Object)dropHoverStyleClass);
    }

    public String getDropActiveStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropActiveStyleClass), null);
    }

    public void setDropActiveStyleClass(String dropActiveStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropActiveStyleClass), (Object)dropActiveStyleClass);
    }

    public String getDropAccept() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropAccept), null);
    }

    public void setDropAccept(String dropAccept) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropAccept), (Object)dropAccept);
    }

    public String getDropScope() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropScope), null);
    }

    public void setDropScope(String dropScope) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropScope), (Object)dropScope);
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("add".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineAddEvent te = new TimelineAddEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")), (String)params.get(clientId + "_group"));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("change".equals(eventName)) {
                TimelineEvent clonedEvent = null;
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                if (timelineEvent != null) {
                    clonedEvent = new TimelineEvent();
                    clonedEvent.setData(timelineEvent.getData());
                    clonedEvent.setEditable(timelineEvent.isEditable());
                    clonedEvent.setStyleClass(timelineEvent.getStyleClass());
                    TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                    TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                    clonedEvent.setStartDate(DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")));
                    clonedEvent.setEndDate(DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")));
                    clonedEvent.setGroup((String)params.get(clientId + "_group"));
                }
                TimelineModificationEvent te = new TimelineModificationEvent((UIComponent)this, behaviorEvent.getBehavior(), clonedEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("edit".equals(eventName) || "delete".equals(eventName)) {
                TimelineEvent clonedEvent = null;
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                if (timelineEvent != null) {
                    clonedEvent = new TimelineEvent();
                    clonedEvent.setData(timelineEvent.getData());
                    clonedEvent.setStartDate((Date)timelineEvent.getStartDate().clone());
                    clonedEvent.setEndDate(timelineEvent.getEndDate() != null ? (Date)timelineEvent.getEndDate().clone() : null);
                    clonedEvent.setEditable(timelineEvent.isEditable());
                    clonedEvent.setGroup(timelineEvent.getGroup());
                    clonedEvent.setStyleClass(timelineEvent.getStyleClass());
                }
                TimelineModificationEvent te = new TimelineModificationEvent((UIComponent)this, behaviorEvent.getBehavior(), clonedEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("select".equals(eventName)) {
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                TimelineSelectEvent te = new TimelineSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), timelineEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("rangechange".equals(eventName) || "rangechanged".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineRangeEvent te = new TimelineRangeEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("lazyload".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineLazyLoadEvent te = new TimelineLazyLoadEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDateFirst")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDateFirst")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDateSecond")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDateSecond")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("drop".equals(eventName)) {
                Object data = null;
                String dragId = (String)params.get(clientId + "_dragId");
                String uiDataId = (String)params.get(clientId + "_uiDataId");
                if (dragId != null && uiDataId != null) {
                    UIDataContextCallback contextCallback = new UIDataContextCallback(dragId);
                    context.getViewRoot().invokeOnComponent(context, uiDataId, (ContextCallback)contextCallback);
                    data = contextCallback.getData();
                }
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineDragDropEvent te = new TimelineDragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")), (String)params.get(clientId + "_group"), dragId, data);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
        }
        super.queueEvent(event);
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get(PropertyKeys.widgetVar.toString());
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        widgetVar,
        value,
        var,
        locale,
        timeZone,
        browserTimeZone,
        style,
        styleClass,
        height,
        minHeight,
        width,
        responsive,
        axisOnTop,
        dragAreaWidth,
        editable,
        selectable,
        unselectable,
        zoomable,
        moveable,
        start,
        end,
        min,
        max,
        zoomMin,
        zoomMax,
        preloadFactor,
        eventMargin,
        eventMarginAxis,
        eventStyle,
        groupsChangeable,
        groupsOnRight,
        groupsWidth,
        snapEvents,
        stackEvents,
        showCurrentTime,
        showMajorLabels,
        showMinorLabels,
        showButtonNew,
        showNavigation,
        dropHoverStyleClass,
        dropActiveStyleClass,
        dropAccept,
        dropScope;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

