/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.codemirror;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.event.PhaseId;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.codemirror.CodeMirror;
import org.primefaces.extensions.event.CompleteEvent;
import org.primefaces.extensions.renderkit.widget.WidgetRenderer;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.renderkit.InputRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeMirrorRenderer
extends InputRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        CodeMirror codeMirror = (CodeMirror)component;
        if (codeMirror.isReadOnly().booleanValue()) {
            return;
        }
        String clientId = codeMirror.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            codeMirror.setSubmittedValue(params.get(clientId));
        }
        this.decodeBehaviors(facesContext, component);
        String token = (String)params.get(clientId + "_token");
        if (token != null) {
            String context = (String)params.get(clientId + "_context");
            int line = Integer.parseInt((String)params.get(clientId + "_line"));
            int column = Integer.parseInt((String)params.get(clientId + "_column"));
            CompleteEvent autoCompleteEvent = new CompleteEvent((UIComponent)codeMirror, token, context, line, column);
            autoCompleteEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            codeMirror.queueEvent(autoCompleteEvent);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CodeMirror codeMirror = (CodeMirror)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String token = (String)params.get(codeMirror.getClientId(context) + "_token");
        if (token != null) {
            this.encodeSuggestions(context, codeMirror, codeMirror.getSuggestions());
        } else {
            this.encodeMarkup(context, codeMirror);
            this.encodeScript(context, codeMirror);
        }
    }

    protected void encodeMarkup(FacesContext context, CodeMirror codeMirror) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = codeMirror.getClientId(context);
        writer.startElement("textarea", (UIComponent)codeMirror);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)codeMirror);
        if (valueToRender != null) {
            if (codeMirror.isEscape()) {
                writer.writeText((Object)valueToRender, null);
            } else {
                writer.write(valueToRender);
            }
        }
        writer.endElement("textarea");
    }

    protected void encodeScript(FacesContext context, CodeMirror codeMirror) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = codeMirror.getClientId(context);
        String widgetVar = codeMirror.resolveWidgetVar();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('" + CodeMirror.class.getSimpleName() + "', '" + widgetVar + "', {");
        WidgetRenderer.renderOptions(clientId, writer, codeMirror);
        if (!codeMirror.isGlobal()) {
            writer.write(",global:false");
        }
        if (codeMirror.getProcess() != null) {
            writer.write(",process:'" + SearchExpressionFacade.resolveComponentsForClient((FacesContext)context, (UIComponent)codeMirror, (String)codeMirror.getProcess()) + "'");
        }
        if (codeMirror.getOnstart() != null) {
            writer.write(",onstart:function(request) {" + codeMirror.getOnstart() + ";}");
        }
        if (codeMirror.getOncomplete() != null) {
            writer.write(",oncomplete:function(xhr, status, args) {" + codeMirror.getOncomplete() + ";}");
        }
        if (codeMirror.getOnsuccess() != null) {
            writer.write(",onsuccess:function(data, status, xhr){" + codeMirror.getOnsuccess() + ";}");
        }
        if (codeMirror.getOnerror() != null) {
            writer.write(",onerror:function(xhr, status, error){" + codeMirror.getOnerror() + ";}");
        }
        if (codeMirror.isAsync()) {
            writer.write(",async:true");
        }
        this.encodeClientBehaviors(context, codeMirror);
        writer.write("}, true);});");
        this.endScript(writer);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        CodeMirror codeMirror = (CodeMirror)component;
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)component);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)codeMirror, value);
        }
        return value;
    }

    protected void encodeSuggestions(FacesContext context, CodeMirror codeMirror, List<String> suggestions) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)codeMirror);
        for (int i = 0; i < suggestions.size(); ++i) {
            String suggestion = suggestions.get(i);
            writer.startElement("li", null);
            if (codeMirror.isEscapeSuggestions()) {
                writer.writeText((Object)suggestion, null);
            } else {
                writer.write(suggestion);
            }
            writer.endElement("li");
        }
        writer.endElement("ul");
    }
}

