/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public record ResultCollector(Object[] results, AtomicInteger counter, Consumer<Object[]> action) {
    public static ResultCollector resultCollector(int count, Consumer<Object[]> action) {
        assert (count >= 0);
        return new ResultCollector(new Object[count], new AtomicInteger(count), action);
    }

    public ResultCollector apply(Consumer<ResultCollector> setup) {
        setup.accept(this);
        return this;
    }

    public void registerEvent(int index, Object value) {
        if (this.counter.get() <= 0) {
            return;
        }
        assert (this.results[index] == null);
        this.results[index] = value;
        if (this.counter.decrementAndGet() == 0) {
            this.action.accept(this.results);
        }
    }
}

