/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.io.TimeSpan;
import org.pragmatica.lang.utils.FluentPredicate;
import org.pragmatica.lang.utils.SharedScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CircuitBreaker {
    public <T> Promise<T> execute(Supplier<Promise<T>> var1);

    public State state();

    public long failureCount();

    public TimeSpan timeSinceLastStateChange();

    public static CircuitBreaker create(int failureThreshold, TimeSpan resetTimeout, int testAttempts, Predicate<Cause> shouldTrip, TimeSource timeSource) {
        record CircuitBreaker(int failureThreshold, TimeSpan resetTimeout, int testAttempts, FluentPredicate<Cause> shouldTrip, AtomicReference<State> stateRef, AtomicLong failureCountRef, AtomicLong lastStateChangeTimestamp, AtomicLong testSuccessCount, TimeSource timeSource) implements org.pragmatica.lang.utils.CircuitBreaker
        {
            private static final Logger log = LoggerFactory.getLogger(org.pragmatica.lang.utils.CircuitBreaker.class);

            @Override
            public State state() {
                return this.stateRef.get();
            }

            @Override
            public long failureCount() {
                return this.failureCountRef.get();
            }

            @Override
            public TimeSpan timeSinceLastStateChange() {
                return TimeSpan.timeSpan(this.timeSource().nanoTime() - this.lastStateChangeTimestamp.get()).nanos();
            }

            @Override
            public <T> Promise<T> execute(Supplier<Promise<T>> operation) {
                return switch (this.stateRef.get().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> this.executeClosedState(operation);
                    case 1 -> {
                        if (this.isResetTimeoutExpired()) {
                            this.transitionTo(State.HALF_OPEN);
                            yield this.executeHalfOpenState(operation);
                        }
                        TimeSpan timeout = TimeSpan.timeSpan(this.resetTimeout.nanos() - (this.timeSource().nanoTime() - this.lastStateChangeTimestamp.get())).nanos();
                        yield new CircuitBreakerErrors.CircuitBreakerOpenError("Circuit breaker is open. Operation rejected.", timeout).promise();
                    }
                    case 2 -> this.executeHalfOpenState(operation);
                };
            }

            private <T> Promise<T> executeClosedState(Supplier<Promise<T>> operation) {
                return operation.get().onSuccessRun(() -> this.failureCountRef.set(0L)).onFailure(cause -> this.shouldTrip.ifTrue((Cause)cause, this::handleFailure));
            }

            private <T> Promise<T> executeHalfOpenState(Supplier<Promise<T>> operation) {
                return operation.get().onSuccess(object -> {
                    long successCount = this.testSuccessCount.incrementAndGet();
                    if (successCount >= (long)this.testAttempts) {
                        this.transitionTo(State.CLOSED);
                    }
                }).onFailure(error -> this.shouldTrip.ifTrue((Cause)error, () -> this.transitionTo(State.OPEN)));
            }

            private void handleFailure() {
                long currentFailures = this.failureCountRef.incrementAndGet();
                if (currentFailures >= (long)this.failureThreshold) {
                    this.transitionTo(State.OPEN);
                }
            }

            private void transitionTo(State newState) {
                State oldState = this.stateRef.getAndSet(newState);
                if (oldState != newState) {
                    this.lastStateChangeTimestamp.set(this.timeSource().nanoTime());
                    log.info("Circuit breaker stateRef changed from {} to {}", (Object)oldState, (Object)newState);
                    switch (newState.ordinal()) {
                        case 1: {
                            this.scheduleReset();
                            break;
                        }
                        case 2: {
                            this.testSuccessCount.set(0L);
                            break;
                        }
                        case 0: {
                            this.failureCountRef.set(0L);
                        }
                    }
                }
            }

            private void scheduleReset() {
                SharedScheduler.schedule(() -> {
                    if (this.stateRef.get() == State.OPEN && this.isResetTimeoutExpired()) {
                        this.transitionTo(State.HALF_OPEN);
                    }
                }, this.resetTimeout);
            }

            private boolean isResetTimeoutExpired() {
                return this.timeSource().nanoTime() - this.lastStateChangeTimestamp.get() >= this.resetTimeout.nanos();
            }
        }
        return new CircuitBreaker(failureThreshold, resetTimeout, testAttempts, FluentPredicate.from(shouldTrip), new AtomicReference<State>(State.CLOSED), new AtomicLong(0L), new AtomicLong(timeSource.nanoTime()), new AtomicLong(0L), timeSource);
    }

    public static StageFailureThreshold builder() {
        return failureThreshold -> resetTimeout -> testAttempts -> shouldTrip -> timeSource -> CircuitBreaker.create(failureThreshold, resetTimeout, testAttempts, shouldTrip, timeSource);
    }

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }

    public static interface TimeSource {
        public long nanoTime();
    }

    public static interface StageFailureThreshold {
        public StageResetTimeout failureThreshold(int var1);
    }

    public static interface StageResetTimeout {
        public StageTestAttempts resetTimeout(TimeSpan var1);
    }

    public static interface StageTestAttempts {
        public StageShouldTrip testAttempts(int var1);

        default public StageShouldTrip withDefaultTestAttempts() {
            return this.testAttempts(5);
        }
    }

    public static interface StageShouldTrip {
        public StateTimeSource shouldTrip(Predicate<Cause> var1);

        default public StateTimeSource withDefaultShouldTrip() {
            return this.shouldTrip(cause -> true);
        }
    }

    public static interface StateTimeSource {
        public CircuitBreaker timeSource(TimeSource var1);

        default public CircuitBreaker withDefaultTimeSource() {
            return this.timeSource(System::nanoTime);
        }
    }

    public static sealed interface CircuitBreakerErrors
    extends Cause {

        public record CircuitBreakerOpenError(String message, TimeSpan retryTime) implements CircuitBreakerErrors
        {
            private final String message;

            @Override
            public String message() {
                return "Circuit breaker is open. " + this.message + ". Will attempt reset in " + String.valueOf(this.retryTime);
            }
        }
    }
}

