/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.Functions;
import org.pragmatica.lang.Option;
import org.pragmatica.lang.Result;

public sealed interface Causes {
    public static Cause cause(String message) {
        return Causes.cause(message, Option.none());
    }

    public static Cause cause(String message, Option<Cause> source) {
        record SimpleCause(String message, Option<Cause> source) implements Causes.SimpleCause
        {
            @Override
            public String toString() {
                return this.completeMessage();
            }
        }
        return new SimpleCause(message, source);
    }

    public static Cause fromThrowable(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return Causes.cause(sw.toString());
    }

    @Deprecated(since="0.8.2", forRemoval=true)
    public static <T> Functions.Fn1<Cause, T> forValue(String template) {
        return Causes.forOneValue(template);
    }

    public static <T> Functions.Fn1<Cause, T> forOneValue(String template) {
        return input -> Causes.cause(String.format(template, input));
    }

    public static <T1, T2> Functions.Fn2<Cause, T1, T2> forTwoValues(String template) {
        return (input1, input2) -> Causes.cause(String.format(template, input1, input2));
    }

    public static <T1, T2, T3> Functions.Fn3<Cause, T1, T2, T3> forThreeValues(String template) {
        return (input1, input2, input3) -> Causes.cause(String.format(template, input1, input2, input3));
    }

    public static CompositeCause composite(Result<?> ... results) {
        ArrayList<Cause> inner = new ArrayList<Cause>();
        for (Result<?> result : results) {
            result.onFailure(inner::add);
        }
        record CompositeCause(Option<Cause> source, List<Cause> causes) implements Causes.CompositeCause
        {
            @Override
            public Causes.CompositeCause append(Cause cause) {
                this.causes().add(cause);
                return this;
            }

            @Override
            public Stream<Cause> stream() {
                return this.causes().stream();
            }

            @Override
            public boolean isEmpty() {
                return this.causes().isEmpty();
            }

            @Override
            public String message() {
                StringBuilder builder = new StringBuilder("Composite:");
                this.stream().forEach(issue -> builder.append("\n  ").append(issue.message()));
                return builder.toString();
            }

            @Override
            public String toString() {
                return this.message();
            }

            @Override
            public Cause replace(Cause input) {
                return this.isEmpty() ? input : this;
            }
        }
        return new CompositeCause(Option.none(), inner);
    }

    public static interface CompositeCause
    extends Cause {
        public static Cause toComposite(String text, Cause cause) {
            if (cause instanceof CompositeCause) {
                CompositeCause composite = (CompositeCause)cause;
                return composite.append(Causes.cause(text));
            }
            return Causes.composite(new Result[0]).append(Causes.cause(text, Option.option(cause)));
        }

        public CompositeCause append(Cause var1);

        public boolean isEmpty();

        public Cause replace(Cause var1);
    }

    public static interface SimpleCause
    extends Cause {
        default public String completeMessage() {
            StringBuilder builder = new StringBuilder("Cause: ");
            this.iterate(issue -> builder.append("\n  ").append(issue.message()));
            return builder.toString();
        }
    }

    public record unused() implements Causes
    {
    }
}

