/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import org.pragmatica.lang.Option;

public abstract class TypeToken<T>
implements Comparable<TypeToken<T>> {
    private final Type token;

    protected TypeToken(Type token) {
        this.token = token;
    }

    protected TypeToken() {
        Type type = this.getClass().getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("TypeToken constructed without actual type argument.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        this.token = parameterizedType.getActualTypeArguments()[0];
    }

    public static <T> TypeToken<T> of(Class<T> clazz) {
        return new TypeToken<T>(clazz){};
    }

    public Type token() {
        return this.token;
    }

    public Class<?> rawType() {
        return TypeToken.rawClass(this.token);
    }

    public Option<Class<?>> typeArgument(int ... indexes) {
        if (indexes.length == 0) {
            return Option.option(TypeToken.rawClass(this.token));
        }
        for (int ndx : indexes) {
            if (ndx >= 0) continue;
            return Option.none();
        }
        return TypeToken.recursivelyGetType(this.token, indexes);
    }

    private static Option<Class<?>> recursivelyGetType(Type type, int ... indexes) {
        int index = indexes[0];
        if (!(type instanceof ParameterizedType)) {
            return Option.none();
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType.getActualTypeArguments().length <= index) {
            return Option.none();
        }
        Type actualTypeArgument = parameterizedType.getActualTypeArguments()[index];
        if (indexes.length == 1) {
            return Option.option(TypeToken.rawClass(actualTypeArgument));
        }
        return TypeToken.recursivelyGetType(actualTypeArgument, Arrays.copyOfRange(indexes, 1, indexes.length));
    }

    private static Class<?> rawClass(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class}, (Type)type3, n)) {
            case 0 -> {
                Class clazz;
                yield clazz = (Class)type3;
            }
            case 1 -> {
                ParameterizedType parameterizedType = (ParameterizedType)type3;
                yield (Class)parameterizedType.getRawType();
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(type));
        };
    }

    public Option<TypeToken<?>> subType(int ... indexes) {
        if (indexes.length == 0) {
            return Option.option(this);
        }
        for (int ndx : indexes) {
            if (ndx >= 0) continue;
            return Option.none();
        }
        return TypeToken.recursivelyGetSubType(this.token, indexes);
    }

    private static Option<TypeToken<?>> recursivelyGetSubType(Type type, int ... indexes) {
        int index = indexes[0];
        if (!(type instanceof ParameterizedType)) {
            return Option.none();
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType.getActualTypeArguments().length <= index) {
            return Option.none();
        }
        Type actualTypeArgument = parameterizedType.getActualTypeArguments()[index];
        if (indexes.length == 1) {
            return Option.option(new TypeToken<Object>(actualTypeArgument){});
        }
        return TypeToken.recursivelyGetSubType(actualTypeArgument, Arrays.copyOfRange(indexes, 1, indexes.length));
    }

    @Override
    public int compareTo(TypeToken<T> o) {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TypeToken) {
            TypeToken typeToken = (TypeToken)o;
            return this.token.equals(typeToken.token);
        }
        return false;
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public String toString() {
        return "TypeToken<" + String.valueOf(this.token) + ">";
    }
}

