/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.parse;

import java.util.Base64;
import java.util.regex.Pattern;
import org.pragmatica.lang.Result;

public sealed interface Text {
    public static <E extends Enum<E>> Result<E> parseEnum(Class<E> enumType, String name) {
        return Result.lift2(Enum::valueOf, enumType, name);
    }

    public static Result<Pattern> compilePattern(String regex) {
        return Result.lift1(Pattern::compile, regex);
    }

    public static Result<Pattern> compilePattern(String regex, int flags) {
        return Result.lift2(Pattern::compile, regex, flags);
    }

    public static Result<byte[]> decodeBase64(String src) {
        return Result.lift1(Base64.getDecoder()::decode, src);
    }

    public static Result<byte[]> decodeBase64URL(String src) {
        return Result.lift1(Base64.getUrlDecoder()::decode, src);
    }

    public static Result<byte[]> decodeBase64MIME(String src) {
        return Result.lift1(Base64.getMimeDecoder()::decode, src);
    }

    public record unused() implements Text
    {
    }
}

