/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.parse;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import org.pragmatica.lang.Result;

public sealed interface Network {
    public static Result<URL> parseURL(String spec) {
        return Result.lift1(URL::new, spec);
    }

    public static Result<URI> parseURI(String str) {
        return Result.lift1(URI::new, str);
    }

    public static Result<UUID> parseUUID(String name) {
        return Result.lift1(UUID::fromString, name);
    }

    public static Result<InetAddress> parseInetAddress(String host) {
        return Result.lift1(InetAddress::getByName, host);
    }

    public record unused() implements Network
    {
    }
}

