/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.io;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.pragmatica.lang.Tuple;

public sealed interface TimeSpan
extends Comparable<TimeSpan> {
    public static final long NANOS_IN_SECOND = TimeUnit.SECONDS.toNanos(1L);
    public static final long MILLIS_IN_SECOND = TimeUnit.MILLISECONDS.toNanos(1L);

    public long nanos();

    default public long micros() {
        return TimeUnit.NANOSECONDS.toMicros(this.nanos());
    }

    default public long millis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanos());
    }

    default public TimeSpan plus(TimeSpan other) {
        return new TimeSpanImpl(this.nanos() + other.nanos());
    }

    default public TimeSpan plus(long value) {
        return this.plus(value, TimeUnit.NANOSECONDS);
    }

    default public TimeSpan plus(long value, TimeUnit unit) {
        return new TimeSpanImpl(this.nanos() + unit.toNanos(value));
    }

    default public Tuple.Tuple2<Long, Integer> secondsAndNanos() {
        return Tuple.tuple(this.nanos() / NANOS_IN_SECOND, (int)(this.nanos() % NANOS_IN_SECOND));
    }

    default public Tuple.Tuple2<Long, Integer> millisAndNanos() {
        return Tuple.tuple(this.nanos() / MILLIS_IN_SECOND, (int)(this.nanos() % MILLIS_IN_SECOND));
    }

    default public Duration duration() {
        return this.secondsAndNanos().map(Duration::ofSeconds);
    }

    @Override
    default public int compareTo(TimeSpan o) {
        return Long.compare(this.nanos(), o.nanos());
    }

    default public TimeSpan randomize(double scale) {
        long random = (long)((Math.random() - 0.5) * 2.0 * scale * (double)this.nanos());
        return TimeSpan.timeSpan(random + this.nanos()).nanos();
    }

    public static TimeSpan fromDuration(Duration duration) {
        return TimeSpan.timeSpan(duration.toNanos()).nanos();
    }

    public static TimeSpanBuilder timeSpan(long value) {
        return () -> value;
    }

    public record TimeSpanImpl(long nanos) implements TimeSpan
    {
        @Override
        public String toString() {
            return "TimeSpan(" + this.duration().toString().substring(2) + ")";
        }
    }

    public static interface TimeSpanBuilder {
        public long value();

        default public TimeSpan nanos() {
            return new TimeSpanImpl(this.value());
        }

        default public TimeSpan micros() {
            return new TimeSpanImpl(TimeUnit.MICROSECONDS.toNanos(this.value()));
        }

        default public TimeSpan millis() {
            return new TimeSpanImpl(TimeUnit.MILLISECONDS.toNanos(this.value()));
        }

        default public TimeSpan seconds() {
            return new TimeSpanImpl(TimeUnit.SECONDS.toNanos(this.value()));
        }

        default public TimeSpan minutes() {
            return new TimeSpanImpl(TimeUnit.MINUTES.toNanos(this.value()));
        }

        default public TimeSpan hours() {
            return new TimeSpanImpl(TimeUnit.HOURS.toNanos(this.value()));
        }

        default public TimeSpan days() {
            return new TimeSpanImpl(TimeUnit.DAYS.toNanos(this.value()));
        }
    }
}

