/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang.io;

import org.pragmatica.lang.Cause;

public sealed interface CoreError
extends Cause {
    public static CoreError emptyOption() {
        return CoreErrors.EMPTY_OPTION;
    }

    public static CoreError exception(Throwable cause) {
        return new Exception(cause);
    }

    public static enum CoreErrors implements CoreError
    {
        EMPTY_OPTION("The instance of Option is empty");

        private final String message;

        private CoreErrors(String message) {
            this.message = message;
        }

        @Override
        public String message() {
            return this.message;
        }
    }

    public record Exception(String message, Throwable cause) implements CoreError
    {
        public Exception(Throwable cause) {
            this(cause.getMessage(), cause);
        }
    }

    public record Fault(String message) implements CoreError
    {
    }

    public record Timeout(String message) implements CoreError
    {
    }

    public record Cancelled(String message) implements CoreError
    {
    }
}

