/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.Functions;
import org.pragmatica.lang.Option;
import org.pragmatica.lang.Result;
import org.pragmatica.lang.utils.Causes;

public sealed interface Verify {
    public static <T> Result<T> ensure(T value, Predicate<T> predicate) {
        return Verify.ensure(Causes.forOneValue("Value {0} does not satisfy the predicate"), value, predicate);
    }

    public static <T> Result<T> ensure(Cause cause, T value, Predicate<T> predicate) {
        return Verify.ensure((T object) -> cause, value, predicate);
    }

    public static <T> Result<T> ensure(Functions.Fn1<Cause, T> causeProvider, T value, Predicate<T> predicate) {
        if (predicate.test(value)) {
            return Result.success(value);
        }
        return causeProvider.apply(value).result();
    }

    public static <T> Functions.Fn1<Result<T>, T> ensureFn(Functions.Fn1<Cause, T> causeProvider, Predicate<T> predicate) {
        return value -> Verify.ensure(causeProvider, value, predicate);
    }

    public static <T> Functions.Fn1<Result<T>, T> ensureFn(Cause cause, Predicate<T> predicate) {
        return value -> Verify.ensure((T object) -> cause, value, predicate);
    }

    public static <T, P1> Result<T> ensure(T value, Functions.Fn2<Boolean, T, P1> predicate, P1 param1) {
        return Verify.ensure(value, v -> (Boolean)predicate.apply(v, param1));
    }

    public static <T, P1> Result<T> ensure(Cause cause, T value, Functions.Fn2<Boolean, T, P1> predicate, P1 param1) {
        return Verify.ensure((T object) -> cause, value, (T v) -> (Boolean)predicate.apply(v, param1));
    }

    public static <T, P1> Functions.Fn1<Result<T>, T> ensureFn(Functions.Fn2<Boolean, T, P1> predicate, P1 param1) {
        return value -> Verify.ensure(value, predicate, param1);
    }

    public static <T, P1> Functions.Fn1<Result<T>, T> ensureFn(Cause cause, Functions.Fn2<Boolean, T, P1> predicate, P1 param1) {
        return value -> Verify.ensure((T object) -> cause, value, predicate, param1);
    }

    public static <T, P1> Result<T> ensure(Functions.Fn1<Cause, T> causeProvider, T value, Functions.Fn2<Boolean, T, P1> predicate, P1 param1) {
        return Verify.ensure(causeProvider, value, (T v) -> (Boolean)predicate.apply(v, param1));
    }

    public static <T, P1> Functions.Fn1<Result<T>, T> ensureFn(Functions.Fn1<Cause, T> causeProvider, Functions.Fn2<Boolean, T, P1> predicate, P1 param1) {
        return value -> Verify.ensure(causeProvider, value, predicate, param1);
    }

    public static <T, P1, P2> Result<T> ensure(T value, Functions.Fn3<Boolean, T, P1, P2> predicate, P1 param1, P2 param2) {
        return Verify.ensure(value, v -> (Boolean)predicate.apply(v, param1, param2));
    }

    public static <T, P1, P2> Result<T> ensure(Cause cause, T value, Functions.Fn3<Boolean, T, P1, P2> predicate, P1 param1, P2 param2) {
        return Verify.ensure((T object) -> cause, value, (T v) -> (Boolean)predicate.apply(v, param1, param2));
    }

    public static <T, P1, P2> Functions.Fn1<Result<T>, T> ensureFn(Functions.Fn3<Boolean, T, P1, P2> predicate, P1 param1, P2 param2) {
        return value -> Verify.ensure(value, predicate, param1, param2);
    }

    public static <T, P1, P2> Functions.Fn1<Result<T>, T> ensureFn(Cause cause, Functions.Fn3<Boolean, T, P1, P2> predicate, P1 param1, P2 param2) {
        return value -> Verify.ensure((T object) -> cause, value, predicate, param1, param2);
    }

    public static <T, P1, P2> Result<T> ensure(Functions.Fn1<Cause, T> causeProvider, T value, Functions.Fn3<Boolean, T, P1, P2> predicate, P1 param1, P2 param2) {
        return Verify.ensure(causeProvider, value, (T v) -> (Boolean)predicate.apply(v, param1, param2));
    }

    public static <T, P1, P2> Functions.Fn1<Result<T>, T> ensureFn(Functions.Fn1<Cause, T> causeProvider, Functions.Fn3<Boolean, T, P1, P2> predicate, P1 param1, P2 param2) {
        return value -> Verify.ensure(causeProvider, value, predicate, param1, param2);
    }

    @SafeVarargs
    public static <T> Functions.Fn1<Result<T>, T> combine(Functions.Fn1<Result<T>, T> ... checks) {
        return value -> {
            for (Functions.Fn1 check : checks) {
                Result result = (Result)check.apply(value);
                if (result.isSuccess()) continue;
                return result;
            }
            return Result.success(value);
        };
    }

    public record unused() implements Verify
    {
    }

    public static interface Is {
        public static <T> boolean some(Option<T> option) {
            return option.isPresent();
        }

        public static <T> boolean none(Option<T> option) {
            return option.isEmpty();
        }

        public static <T extends Number> boolean positive(T value) {
            return value.doubleValue() > 0.0;
        }

        public static <T extends Number> boolean negative(T value) {
            return value.doubleValue() < 0.0;
        }

        public static <T extends Number> boolean nonNegative(T value) {
            return value.doubleValue() >= 0.0;
        }

        public static <T extends Number> boolean nonPositive(T value) {
            return value.doubleValue() <= 0.0;
        }

        public static <T extends Comparable<T>> boolean greaterThan(T value, T boundary) {
            return value.compareTo(boundary) > 0;
        }

        public static <T extends Comparable<T>> boolean greaterThanOrEqualTo(T value, T boundary) {
            return value.compareTo(boundary) >= 0;
        }

        public static <T extends Comparable<T>> boolean lessThan(T value, T boundary) {
            return value.compareTo(boundary) < 0;
        }

        public static <T extends Comparable<T>> boolean lessThanOrEqualTo(T value, T boundary) {
            return value.compareTo(boundary) <= 0;
        }

        public static <T extends Comparable<T>> boolean equalTo(T value, T boundary) {
            return value.compareTo(boundary) == 0;
        }

        public static <T extends Comparable<T>> boolean notEqualTo(T value, T boundary) {
            return value.compareTo(boundary) != 0;
        }

        public static <T extends Comparable<T>> boolean between(T value, T min, T max) {
            return Is.greaterThanOrEqualTo(value, min) && Is.lessThanOrEqualTo(value, max);
        }

        public static <T> boolean notNull(T value) {
            return value != null;
        }

        public static <T extends CharSequence> boolean empty(T value) {
            return value.isEmpty();
        }

        public static <T extends CharSequence> boolean notEmpty(T value) {
            return !Is.empty(value);
        }

        public static <T extends CharSequence> boolean blank(T value) {
            return value.chars().allMatch(Character::isWhitespace);
        }

        public static <T extends CharSequence> boolean notBlank(T value) {
            return !Is.blank(value);
        }

        public static <T extends CharSequence> boolean lenBetween(T value, int minLen, int maxLen) {
            return value.length() >= minLen && value.length() <= maxLen;
        }

        public static boolean contains(String value, CharSequence substring) {
            return value.contains(substring.toString());
        }

        public static boolean notContains(String value, CharSequence substring) {
            return !Is.contains(value, substring);
        }

        public static boolean matches(String value, String regex) {
            return value.matches(regex);
        }

        public static boolean matches(String value, Pattern regex) {
            return regex.matcher(value).matches();
        }
    }
}

