/*
 * Decompiled with CFR 0.152.
 */
package org.pragmatica.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.pragmatica.lang.Cause;
import org.pragmatica.lang.ExpectationMismatchError;
import org.pragmatica.lang.Functions;
import org.pragmatica.lang.Promise;
import org.pragmatica.lang.Result;
import org.pragmatica.lang.Tuple;
import org.pragmatica.lang.io.CoreError;

public sealed interface Option<T> {
    public static final None NONE = new None();

    default public <U> Option<U> map(Functions.Fn1<U, ? super T> mapper) {
        return this.fold(Option::empty, t -> Option.present(mapper.apply((Object)t)));
    }

    default public <U> Option<U> map(Supplier<U> supplier) {
        return this.fold(Option::empty, object -> Option.present(supplier.get()));
    }

    default public <U> Option<U> flatMap(Functions.Fn1<Option<U>, ? super T> mapper) {
        return this.fold(Option::empty, mapper);
    }

    default public <U> Option<U> flatMap(Supplier<Option<U>> supplier) {
        return this.fold(Option::empty, object -> (Option)supplier.get());
    }

    default public Option<T> filter(Predicate<? super T> predicate) {
        return this.fold(Option::empty, v -> predicate.test(v) ? this : Option.empty());
    }

    default public Option<T> onPresent(Consumer<? super T> consumer) {
        this.apply(Functions::unitFn, consumer);
        return this;
    }

    default public Option<T> onPresentRun(Runnable runnable) {
        return this.onPresent(object -> runnable.run());
    }

    default public Option<T> onEmpty(Runnable action) {
        this.apply(action, Functions::unitFn);
        return this;
    }

    default public Option<T> onEmptyRun(Runnable action) {
        return this.onEmpty(action);
    }

    default public Option<T> apply(Runnable emptyValConsumer, Consumer<? super T> nonEmptyValConsumer) {
        this.fold(() -> {
            emptyValConsumer.run();
            return null;
        }, t2 -> {
            nonEmptyValConsumer.accept(t2);
            return null;
        });
        return this;
    }

    default public T or(T replacement) {
        return (T)this.fold(() -> replacement, Functions::id);
    }

    default public T or(Supplier<T> supplier) {
        return (T)this.fold(supplier, Functions::id);
    }

    default public Option<T> orElse(Option<T> replacement) {
        return this.fold(() -> replacement, object -> this);
    }

    default public Option<T> orElse(Supplier<Option<T>> supplier) {
        return this.fold(supplier, object -> this);
    }

    default public boolean isPresent() {
        return this.fold(() -> false, object -> true);
    }

    default public boolean isEmpty() {
        return this.fold(() -> true, object -> false);
    }

    default public Stream<T> stream() {
        return this.fold(Stream::empty, Stream::of);
    }

    default public Result<T> toResult(Cause cause) {
        return this.fold(cause::result, Result::success);
    }

    default public Result<T> await(Cause cause) {
        return this.toResult(cause);
    }

    default public Result<T> toResult() {
        return this.toResult(CoreError.emptyOption());
    }

    default public Result<T> await() {
        return this.toResult();
    }

    default public Result<T> toResult(Supplier<Result<T>> supplier) {
        return this.fold(supplier, Result::success);
    }

    default public Result<T> await(Supplier<Result<T>> supplier) {
        return this.toResult(supplier);
    }

    default public Promise<T> async(Cause cause) {
        return this.fold(cause::promise, Promise::success);
    }

    default public Promise<T> async() {
        return this.async(CoreError.emptyOption());
    }

    default public Promise<T> async(Supplier<Promise<T>> supplier) {
        return this.fold(supplier, Promise::success);
    }

    default public Optional<T> toOptional() {
        return this.fold(Optional::empty, Optional::of);
    }

    public <U> U fold(Supplier<? extends U> var1, Functions.Fn1<? extends U, ? super T> var2);

    public static <T> Option<T> option(T value) {
        return value == null ? Option.empty() : Option.present(value);
    }

    public static <T> Option<T> from(Optional<T> optional) {
        return Option.option(optional.orElse(null));
    }

    public static <U> Option<U> empty() {
        return NONE;
    }

    public static <U> Option<U> none() {
        return NONE;
    }

    public static <U> Option<U> present(U value) {
        return new Some<U>(value);
    }

    public static <U> Option<U> some(U value) {
        return new Some<U>(value);
    }

    @Deprecated
    default public T unwrap() {
        return (T)this.fold(() -> {
            throw new IllegalStateException("Option is empty!!!");
        }, Functions::id);
    }

    default public T expect(String message) {
        return (T)this.fold(() -> {
            throw new ExpectationMismatchError("Unexpected empty Option: " + message);
        }, Functions::id);
    }

    public static <R, T> Option<R> lift1(Functions.Fn1<R, T> function, T inputValue) {
        return Option.lift(() -> function.apply(inputValue));
    }

    public static <R, T1, T2> Option<R> lift2(Functions.Fn2<R, T1, T2> function, T1 inputValue1, T2 inputValue2) {
        return Option.lift(() -> function.apply(inputValue1, inputValue2));
    }

    public static <R, T1, T2, T3> Option<R> lift3(Functions.Fn3<R, T1, T2, T3> function, T1 inputValue1, T2 inputValue2, T3 inputValue3) {
        return Option.lift(() -> function.apply(inputValue1, inputValue2, inputValue3));
    }

    public static <R> Option<R> lift(Functions.Fn0<R> function) {
        try {
            return Option.option(function.apply());
        }
        catch (Throwable e) {
            return Option.empty();
        }
    }

    @SafeVarargs
    public static <T> Option<T> any(Option<T> ... ops) {
        for (Option<T> option : ops) {
            if (!option.isPresent()) continue;
            return option;
        }
        return Option.empty();
    }

    @SafeVarargs
    public static <T> Option<T> any(Option<T> op, Supplier<Option<T>> ... ops) {
        return op.fold(() -> {
            for (Supplier option : ops) {
                Option result = (Option)option.get();
                if (!result.isPresent()) continue;
                return result;
            }
            return op;
        }, object -> op);
    }

    @SafeVarargs
    public static <T> Option<List<T>> allOf(Option<T> ... values) {
        return Option.allOf(List.of(values));
    }

    public static <T> Option<List<T>> allOf(List<Option<T>> values) {
        ArrayList result = new ArrayList();
        for (Option<Object> option : values) {
            if (option.isEmpty()) {
                return Option.empty();
            }
            option.onPresent(result::add);
        }
        return Option.present(result);
    }

    public static <T1> Mapper1<T1> all(Option<T1> op1) {
        return () -> op1.flatMap((? super T v1) -> Option.some(Tuple.tuple(v1)));
    }

    public static <T1, T2> Mapper2<T1, T2> all(Option<T1> op1, Option<T2> op2) {
        return () -> op1.flatMap((? super T v1) -> op2.flatMap((? super T v2) -> Option.some(Tuple.tuple(v1, v2))));
    }

    public static <T1, T2, T3> Mapper3<T1, T2, T3> all(Option<T1> op1, Option<T2> op2, Option<T3> op3) {
        return () -> op1.flatMap((? super T v1) -> op2.flatMap((? super T v2) -> op3.flatMap((? super T v3) -> Option.some(Tuple.tuple(v1, v2, v3)))));
    }

    public static <T1, T2, T3, T4> Mapper4<T1, T2, T3, T4> all(Option<T1> op1, Option<T2> op2, Option<T3> op3, Option<T4> op4) {
        return () -> op1.flatMap((? super T v1) -> op2.flatMap((? super T v2) -> op3.flatMap((? super T v3) -> op4.flatMap((? super T v4) -> Option.some(Tuple.tuple(v1, v2, v3, v4))))));
    }

    public static <T1, T2, T3, T4, T5> Mapper5<T1, T2, T3, T4, T5> all(Option<T1> op1, Option<T2> op2, Option<T3> op3, Option<T4> op4, Option<T5> op5) {
        return () -> op1.flatMap((? super T v1) -> op2.flatMap((? super T v2) -> op3.flatMap((? super T v3) -> op4.flatMap((? super T v4) -> op5.flatMap((? super T v5) -> Option.some(Tuple.tuple(v1, v2, v3, v4, v5)))))));
    }

    public static <T1, T2, T3, T4, T5, T6> Mapper6<T1, T2, T3, T4, T5, T6> all(Option<T1> op1, Option<T2> op2, Option<T3> op3, Option<T4> op4, Option<T5> op5, Option<T6> op6) {
        return () -> op1.flatMap((? super T v1) -> op2.flatMap((? super T v2) -> op3.flatMap((? super T v3) -> op4.flatMap((? super T v4) -> op5.flatMap((? super T v5) -> op6.flatMap((? super T v6) -> Option.some(Tuple.tuple(v1, v2, v3, v4, v5, v6))))))));
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Mapper7<T1, T2, T3, T4, T5, T6, T7> all(Option<T1> op1, Option<T2> op2, Option<T3> op3, Option<T4> op4, Option<T5> op5, Option<T6> op6, Option<T7> op7) {
        return () -> op1.flatMap((? super T v1) -> op2.flatMap((? super T v2) -> op3.flatMap((? super T v3) -> op4.flatMap((? super T v4) -> op5.flatMap((? super T v5) -> op6.flatMap((? super T v6) -> op7.flatMap((? super T v7) -> Option.some(Tuple.tuple(v1, v2, v3, v4, v5, v6, v7)))))))));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Mapper8<T1, T2, T3, T4, T5, T6, T7, T8> all(Option<T1> op1, Option<T2> op2, Option<T3> op3, Option<T4> op4, Option<T5> op5, Option<T6> op6, Option<T7> op7, Option<T8> op8) {
        return () -> op1.flatMap((? super T v1) -> op2.flatMap((? super T v2) -> op3.flatMap((? super T v3) -> op4.flatMap((? super T v4) -> op5.flatMap((? super T v5) -> op6.flatMap((? super T v6) -> op7.flatMap((? super T v7) -> op8.flatMap((? super T v8) -> Option.some(Tuple.tuple(v1, v2, v3, v4, v5, v6, v7, v8))))))))));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Mapper9<T1, T2, T3, T4, T5, T6, T7, T8, T9> all(Option<T1> op1, Option<T2> op2, Option<T3> op3, Option<T4> op4, Option<T5> op5, Option<T6> op6, Option<T7> op7, Option<T8> op8, Option<T9> op9) {
        return () -> op1.flatMap((? super T v1) -> op2.flatMap((? super T v2) -> op3.flatMap((? super T v3) -> op4.flatMap((? super T v4) -> op5.flatMap((? super T v5) -> op6.flatMap((? super T v6) -> op7.flatMap((? super T v7) -> op8.flatMap((? super T v8) -> op9.flatMap((? super T v9) -> Option.some(Tuple.tuple(v1, v2, v3, v4, v5, v6, v7, v8, v9)))))))))));
    }

    public record None<T>() implements Option<T>
    {
        @Override
        public <U> U fold(Supplier<? extends U> emptyMapper, Functions.Fn1<? extends U, ? super T> presentMapper) {
            return emptyMapper.get();
        }

        @Override
        public String toString() {
            return "None()";
        }
    }

    public record Some<T>(T value) implements Option<T>
    {
        @Override
        public <U> U fold(Supplier<? extends U> emptyMapper, Functions.Fn1<? extends U, ? super T> presentMapper) {
            return presentMapper.apply(this.value);
        }

        @Override
        public String toString() {
            return "Some(" + String.valueOf(this.value) + ")";
        }
    }

    @FunctionalInterface
    public static interface Mapper1<T1> {
        public Option<Tuple.Tuple1<T1>> id();

        default public <R> Option<R> map(Functions.Fn1<R, T1> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn1<Option<R>, T1> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }

    @FunctionalInterface
    public static interface Mapper2<T1, T2> {
        public Option<Tuple.Tuple2<T1, T2>> id();

        default public <R> Option<R> map(Functions.Fn2<R, T1, T2> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn2<Option<R>, T1, T2> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }

    @FunctionalInterface
    public static interface Mapper3<T1, T2, T3> {
        public Option<Tuple.Tuple3<T1, T2, T3>> id();

        default public <R> Option<R> map(Functions.Fn3<R, T1, T2, T3> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn3<Option<R>, T1, T2, T3> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }

    @FunctionalInterface
    public static interface Mapper4<T1, T2, T3, T4> {
        public Option<Tuple.Tuple4<T1, T2, T3, T4>> id();

        default public <R> Option<R> map(Functions.Fn4<R, T1, T2, T3, T4> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn4<Option<R>, T1, T2, T3, T4> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }

    @FunctionalInterface
    public static interface Mapper5<T1, T2, T3, T4, T5> {
        public Option<Tuple.Tuple5<T1, T2, T3, T4, T5>> id();

        default public <R> Option<R> map(Functions.Fn5<R, T1, T2, T3, T4, T5> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn5<Option<R>, T1, T2, T3, T4, T5> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }

    @FunctionalInterface
    public static interface Mapper6<T1, T2, T3, T4, T5, T6> {
        public Option<Tuple.Tuple6<T1, T2, T3, T4, T5, T6>> id();

        default public <R> Option<R> map(Functions.Fn6<R, T1, T2, T3, T4, T5, T6> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn6<Option<R>, T1, T2, T3, T4, T5, T6> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }

    @FunctionalInterface
    public static interface Mapper7<T1, T2, T3, T4, T5, T6, T7> {
        public Option<Tuple.Tuple7<T1, T2, T3, T4, T5, T6, T7>> id();

        default public <R> Option<R> map(Functions.Fn7<R, T1, T2, T3, T4, T5, T6, T7> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn7<Option<R>, T1, T2, T3, T4, T5, T6, T7> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }

    @FunctionalInterface
    public static interface Mapper8<T1, T2, T3, T4, T5, T6, T7, T8> {
        public Option<Tuple.Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> id();

        default public <R> Option<R> map(Functions.Fn8<R, T1, T2, T3, T4, T5, T6, T7, T8> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn8<Option<R>, T1, T2, T3, T4, T5, T6, T7, T8> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }

    @FunctionalInterface
    public static interface Mapper9<T1, T2, T3, T4, T5, T6, T7, T8, T9> {
        public Option<Tuple.Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> id();

        default public <R> Option<R> map(Functions.Fn9<R, T1, T2, T3, T4, T5, T6, T7, T8, T9> mapper) {
            return this.id().map((? super T tuple) -> tuple.map(mapper));
        }

        default public <R> Option<R> flatMap(Functions.Fn9<Option<R>, T1, T2, T3, T4, T5, T6, T7, T8, T9> mapper) {
            return this.id().flatMap((? super T tuple) -> (Option)tuple.map(mapper));
        }
    }
}

