/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.Office;
import org.springframework.beans.factory.annotation.Autowired;

public class Appliance {
    protected static Logger log = LogManager.getLogger((String)Appliance.class.getName());
    @Autowired
    protected RandomSeedRepo randomSeedRepo;
    protected String name;
    protected Office applianceOf;
    protected double saturation;
    protected int power;
    protected int overallPower;
    protected int cycleDuration;
    Vector<Vector<Boolean>> possibilityOperationVector = new Vector();
    Vector<Boolean> operationDaysVector = new Vector();
    Vector<Boolean> dailyOperation = new Vector();
    Vector<Vector<Boolean>> weeklyOperation = new Vector();
    Vector<Integer> loadVector = new Vector();
    Vector<Vector<Integer>> weeklyLoadVector = new Vector();
    int times;
    RandomSeed gen;

    public int getPower() {
        return this.power;
    }

    public int getOverallPower() {
        return this.overallPower;
    }

    public Office getApplianceOf() {
        return this.applianceOf;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public int getDuration() {
        return this.cycleDuration;
    }

    public Vector<Vector<Boolean>> getWeeklyOperation() {
        return this.weeklyOperation;
    }

    public Vector<Vector<Integer>> getWeeklyLoadVector() {
        return this.weeklyLoadVector;
    }

    public Vector<Boolean> getOperationDaysVector() {
        return this.operationDaysVector;
    }

    public void setApplianceOf(Office office) {
        this.applianceOf = office;
    }

    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        return new Vector<Boolean>();
    }

    public void createWeeklyPossibilityOperationVector() {
        for (int i = 0; i < 7; ++i) {
            this.possibilityOperationVector.add(this.createDailyPossibilityOperationVector(i));
        }
    }

    public void initialize(String office, Properties conf, int seed) {
    }

    public double[] dailyShifting(Tariff tariff, double[] nonDominantLoad, TariffEvaluationHelper tariffEvalHelper, int day, Instant start) {
        return new double[24];
    }

    boolean[] createShiftingOperationMatrix(int day) {
        boolean[] shiftingOperationMatrix = new boolean[24];
        for (int i = 0; i < 24; ++i) {
            boolean function;
            shiftingOperationMatrix[i] = function = this.possibilityOperationVector.get(day).get(i * 4) != false || this.possibilityOperationVector.get(day).get(i * 4 + 1) != false || this.possibilityOperationVector.get(day).get(i * 4 + 2) != false || this.possibilityOperationVector.get(day).get(i * 4 + 3) != false;
        }
        return shiftingOperationMatrix;
    }

    public void fillDailyOperation(int times) {
    }

    public void fillWeeklyOperation() {
        for (int i = 0; i < 7; ++i) {
            this.fillDailyOperation(i);
        }
    }

    public void showStatus() {
        log.debug("Name = " + this.name);
        log.debug("Member Of = " + this.applianceOf.toString());
        log.debug("Saturation = " + this.saturation);
        log.debug("Power = " + this.power);
        log.debug("Cycle Duration = " + this.cycleDuration);
        log.debug("Weekly Operation Vector and Load = ");
        for (int i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.debug("Day " + i);
            ListIterator<Boolean> iter = this.weeklyOperation.get(i).listIterator();
            ListIterator<Integer> iter2 = this.weeklyLoadVector.get(i).listIterator();
            for (int j = 0; j < 96; ++j) {
                log.debug("Quarter " + j + " = " + iter.next() + "   Load = " + iter2.next());
            }
        }
    }

    public void weatherDailyFunction(int day, int hour, double temp) {
    }

    public void refresh() {
    }

    public void setOperationDays() {
        for (int i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            boolean function = false;
            for (int j = 0; j < 96; ++j) {
                function = function || this.weeklyOperation.get(i).get(j) != false;
            }
            this.operationDaysVector.add(function);
        }
    }

    public void calculateOverallPower() {
        this.overallPower = -1;
    }

    public String toString() {
        return this.name;
    }
}

