/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.FullyShiftingAppliance;

public class VendingMachine
extends FullyShiftingAppliance {
    @Override
    public void initialize(String office, Properties conf, int seed) {
        this.name = office + " Vending Machine";
        this.saturation = Double.parseDouble(conf.getProperty("VendingMachineSaturation"));
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.power = (int)(40.0 * this.gen.nextGaussian() + 240.0);
        this.cycleDuration = 4;
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            possibilityDailyOperation.add(true);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        int k = this.gen.nextInt(this.cycleDuration);
        for (int i = 0; i < 96; ++i) {
            if (i % this.cycleDuration == k) {
                this.loadVector.add(this.power);
                this.dailyOperation.add(true);
                continue;
            }
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

