/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import org.joda.time.Instant;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.SemiShiftingAppliance;

public class CopyMachine
extends SemiShiftingAppliance {
    private int standbyPower;

    @Override
    public void initialize(String office, Properties conf, int seed) {
        this.name = office + " CopyMachine";
        this.saturation = Double.parseDouble(conf.getProperty("CopyMachineSaturation"));
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.power = (int)(54.0 * this.gen.nextGaussian() + 350.0);
        this.standbyPower = (int)(14.0 * this.gen.nextGaussian() + 74.0);
        this.cycleDuration = 1;
        this.times = Integer.parseInt(conf.getProperty("CopyMachineDailyTimes")) + this.applianceOf.getMembers().size() / 5;
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isWorking(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        int i;
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        Vector<Integer> temp = new Vector<Integer>();
        for (i = 0; i < 96; ++i) {
            if (i > 32 && i < 84 && !this.applianceOf.isOnVacation(weekday)) {
                this.loadVector.add(this.standbyPower);
                this.dailyOperation.add(true);
                int count = this.applianceOf.employeeNumber(weekday, i);
                for (int j = 0; j < count; ++j) {
                    temp.add(i);
                }
                continue;
            }
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        if (temp.size() > 0) {
            for (i = 0; i < this.times; ++i) {
                int rand = this.gen.nextInt(temp.size());
                int quarter = (Integer)temp.get(rand);
                this.loadVector.set(quarter, this.power);
                temp.remove(rand);
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public double[] dailyShifting(Tariff tariff, double[] nonDominantUsage, TariffEvaluationHelper tariffEvalHelper, int day, Instant start) {
        double[] newControllableLoad = new double[24];
        double[] newTemp = new double[24];
        for (int j = 8; j < 21; ++j) {
            newControllableLoad[j] = 4 * this.standbyPower;
        }
        for (int i = 0; i < this.times; ++i) {
            int minIndex = -1;
            int counter = 1;
            double minCost = Double.POSITIVE_INFINITY;
            for (int j = 8; j < 21; ++j) {
                newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
                int n = j;
                newTemp[n] = newTemp[n] + (double)(4 * this.power);
                double cost = Math.abs(tariffEvalHelper.estimateCost(tariff, newTemp, start));
                if (minCost == cost) {
                    ++counter;
                }
                if (!(minCost > cost) && (minCost != cost || !((double)this.gen.nextFloat() > 0.6))) continue;
                minCost = cost;
                minIndex = j;
            }
            if (counter == 13 || minIndex == -1) {
                minIndex = (int)(this.gen.nextDouble() * (double)counter) + 8;
            }
            log.debug((Object)("Less costly hour: " + minIndex));
            int n = minIndex;
            newControllableLoad[n] = newControllableLoad[n] + (double)this.power;
            newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
            int n2 = minIndex;
            newTemp[n2] = newTemp[n2] + (double)this.power;
            nonDominantUsage = Arrays.copyOf(newTemp, newTemp.length);
        }
        return newControllableLoad;
    }

    @Override
    public void calculateOverallPower() {
        int i;
        this.overallPower = 0;
        for (i = 8; i < 21; ++i) {
            this.overallPower += 4 * this.standbyPower;
        }
        for (i = 0; i < this.times; ++i) {
            this.overallPower += this.power - this.standbyPower;
        }
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

