/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.OfficeComplex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfficeComplexCustomerService
extends TimeslotPhaseProcessor
implements NewTariffListener,
InitializationService {
    private static Logger log = Logger.getLogger((String)OfficeComplexCustomerService.class.getName());
    @Autowired
    private TariffMarket tariffMarketService;
    @Autowired
    private ServerConfiguration serverPropertiesService;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    private RandomSeed rs1;
    int seedId = 1;
    private String configFile1 = null;
    private int daysOfCompetition = 0;
    Properties configuration = new Properties();
    ArrayList<OfficeComplex> officeComplexList = new ArrayList();

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("DefaultBroker");
        if (index == -1) {
            return null;
        }
        this.serverPropertiesService.configureMe((Object)this);
        this.officeComplexList.clear();
        this.tariffMarketService.registerNewTariffListener((NewTariffListener)this);
        this.rs1 = this.randomSeedRepo.getRandomSeed("OfficeComplexCustomerService", 1L, "Office Complex Customer Models");
        if (this.configFile1 == null) {
            log.info((Object)"No Config File for OfficeComplexType1 Taken");
            this.configFile1 = "OfficeComplexDefault.properties";
        }
        super.init();
        this.daysOfCompetition = Competition.currentCompetition().getExpectedTimeslotCount() / 24;
        OfficeComplexConstants.setDaysOfWeek();
        OfficeComplexConstants.setDaysOfCompetition(this.daysOfCompetition);
        this.daysOfCompetition = OfficeComplexConstants.DAYS_OF_COMPETITION;
        if (this.daysOfCompetition == 0) {
            log.info((Object)"No Days Of Competition Taken");
            this.daysOfCompetition = 63;
        }
        this.addOfficeComplexes(this.configFile1, "1");
        return "OfficeComplexCustomer";
    }

    private void addOfficeComplexes(String configFile, String type) {
        InputStream cfgFile = null;
        cfgFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile1);
        try {
            this.configuration.load(cfgFile);
            cfgFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] types = new String[]{"NS", "SS"};
        String[] shifts = new String[]{"Base", "Controllable"};
        TreeMap<String, Integer> offices = new TreeMap<String, Integer>();
        int numberOfOfficeComplexes = Integer.parseInt(this.configuration.getProperty("NumberOfOfficeComplexes"));
        int nsoffices = Integer.parseInt(this.configuration.getProperty("NotShiftingCustomers"));
        offices.put("NS", nsoffices);
        int ssoffices = Integer.parseInt(this.configuration.getProperty("SmartShiftingCustomers"));
        offices.put("SS", ssoffices);
        Comparator<CustomerInfo> comp = new Comparator<CustomerInfo>(){

            @Override
            public int compare(CustomerInfo customer1, CustomerInfo customer2) {
                return customer1.getName().compareToIgnoreCase(customer2.getName());
            }
        };
        for (int i = 1; i < numberOfOfficeComplexes + 1; ++i) {
            OfficeComplex officeComplex = new OfficeComplex("OfficeComplex " + i);
            TreeMap<CustomerInfo, String> map = new TreeMap<CustomerInfo, String>(comp);
            for (String officeType : types) {
                for (String shifting : shifts) {
                    CustomerInfo officeComplexInfo = new CustomerInfo("OfficeComplex " + i + " " + officeType + " " + shifting, ((Integer)offices.get(officeType)).intValue());
                    if (shifting.equalsIgnoreCase("Base")) {
                        officeComplexInfo.withPowerType(PowerType.CONSUMPTION);
                    } else {
                        officeComplexInfo.withPowerType(PowerType.INTERRUPTIBLE_CONSUMPTION);
                    }
                    map.put(officeComplexInfo, officeType + " " + shifting);
                    officeComplex.addCustomerInfo(officeComplexInfo);
                }
            }
            officeComplex.initialize(this.configuration, this.seedId++, map);
            this.officeComplexList.add(officeComplex);
            officeComplex.subscribeDefault();
        }
    }

    public void publishNewTariffs(List<Tariff> tariffs) {
        for (OfficeComplex officeComplex : this.officeComplexList) {
            officeComplex.evaluateNewTariffs();
        }
    }

    public int getDaysOfCompetition() {
        return this.daysOfCompetition;
    }

    @ConfigurableValue(valueType="Integer", description="The competition duration in days")
    public void setDaysOfCompetition(int days) {
        this.daysOfCompetition = days;
    }

    public String getConfigFile1() {
        return this.configFile1;
    }

    @ConfigurableValue(valueType="String", description="first configuration file of the office complex customers")
    public void setConfigFile1(String config) {
        this.configFile1 = config;
    }

    public List<OfficeComplex> getOfficeComplexList() {
        return this.officeComplexList;
    }

    public void clearConfiguration() {
        this.configFile1 = null;
    }

    public List<CustomerInfo> generateCustomerInfoList() {
        ArrayList<CustomerInfo> result = new ArrayList<CustomerInfo>();
        for (OfficeComplex officeComplex : this.officeComplexList) {
            for (CustomerInfo customer : officeComplex.getCustomerInfo()) {
                result.add(customer);
            }
        }
        return result;
    }

    public void activate(Instant time, int phaseNumber) {
        log.info((Object)"Activate");
        if (this.officeComplexList.size() > 0) {
            for (OfficeComplex officeComplex : this.officeComplexList) {
                officeComplex.step();
            }
        }
    }

    public void setDefaults() {
    }
}

