/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.persons;

import java.util.Collections;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.Office;
import org.powertac.officecomplexcustomer.enumerations.Status;

public class Person {
    protected static Logger log = Logger.getLogger((String)Person.class.getName());
    String name;
    Status status;
    Office memberOf;
    Vector<Integer> workingDays = new Vector();
    Vector<Integer> vacationVector = new Vector();
    Vector<Integer> publicVacationVector = new Vector();
    Vector<Integer> sicknessVector = new Vector();
    Vector<Status> dailyRoutine = new Vector();
    Vector<Vector<Status>> weeklyRoutine = new Vector();
    Random gen;

    public void initialize(String AgentName, Properties conf, Vector<Integer> publicVacationVector, Random gen) {
    }

    boolean isAtHome() {
        return this.status == Status.Home;
    }

    boolean isAtWork() {
        return this.status == Status.Working;
    }

    boolean isOnBreak() {
        return this.status == Status.Break;
    }

    boolean isVacation() {
        return this.status == Status.Vacation;
    }

    boolean isSick() {
        return this.status == Status.Sick;
    }

    public Vector<Vector<Status>> getWeeklyRoutine() {
        return this.weeklyRoutine;
    }

    public Vector<Status> getDailyRoutine() {
        return this.dailyRoutine;
    }

    Vector<Integer> createSicknessVector(double mean, double dev, Random gen) {
        int days = (int)(dev * gen.nextGaussian() + mean);
        Vector<Integer> v = new Vector<Integer>(days);
        for (int i = 0; i < days; ++i) {
            int x = gen.nextInt(OfficeComplexConstants.DAYS_OF_COMPETITION + 14) + 1;
            ListIterator<Integer> iter = v.listIterator();
            while (iter.hasNext()) {
                int temp = iter.next();
                if (x != temp) continue;
                ++x;
                iter = v.listIterator();
            }
            v.add(x);
        }
        Collections.sort(v);
        return v;
    }

    public void setMemberOf(Office house) {
        this.memberOf = house;
    }

    public void fillDailyRoutine(int day, Random gen) {
        int weekday = day % 7;
        this.dailyRoutine = new Vector();
        if (this.sicknessVector.contains(day)) {
            this.fillSick();
        } else if (this.publicVacationVector.contains(day) || this.vacationVector.contains(day)) {
            for (int i = 0; i < 96; ++i) {
                Status st = Status.Vacation;
                this.dailyRoutine.add(st);
            }
        } else {
            this.normalFill();
            int index = this.workingDays.indexOf(weekday);
            if (index > -1) {
                this.fillWork();
            }
        }
    }

    void normalFill() {
        for (int i = 0; i < 96; ++i) {
            Status st = Status.Home;
            this.dailyRoutine.add(st);
        }
    }

    void fillSick() {
        for (int i = 0; i < 96; ++i) {
            Status st = Status.Sick;
            this.dailyRoutine.add(st);
        }
    }

    void fillWork() {
    }

    public void showInfo() {
    }

    public void refresh(Properties config, Random gen) {
    }

    public String toString() {
        return this.name;
    }
}

