/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.powertac.officecomplexcustomer.appliances.NotShiftingAppliance;

public class ICT
extends NotShiftingAppliance {
    @Override
    public void initialize(String household, Properties conf, Random gen) {
        this.name = household + " ICT";
        this.saturation = 1.0;
        this.power = (int)(25.0 * gen.nextGaussian() + 150.0);
        this.cycleDuration = 1;
        this.times = Integer.parseInt(conf.getProperty("ICTDailyTimes")) + this.applianceOf.getMembers().size() / 5;
    }

    @Override
    public void fillDailyOperation(int weekday, Random gen) {
        int i;
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i2 = 0; i2 < 96; ++i2) {
            this.dailyOperation.add(false);
            this.loadVector.add(0);
        }
        Vector<Integer> temp = new Vector<Integer>();
        for (i = 0; i < 96; ++i) {
            int count = this.applianceOf.employeeNumber(weekday, i);
            for (int j = 0; j < count; ++j) {
                temp.add(i);
            }
        }
        if (temp.size() > 0) {
            for (i = 0; i < this.times; ++i) {
                int rand = gen.nextInt(temp.size());
                int quarter = (Integer)temp.get(rand);
                this.dailyOperation.set(quarter, true);
                this.loadVector.set(quarter, (Integer)this.loadVector.get(quarter) + this.power);
                temp.remove(rand);
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh(Random gen) {
        this.fillWeeklyOperation(gen);
        this.createWeeklyPossibilityOperationVector();
    }
}

