/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.ListIterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.Office;

public class Appliance {
    protected static Logger log = Logger.getLogger((String)Appliance.class.getName());
    protected String name;
    protected Office applianceOf;
    protected double saturation;
    protected int power;
    protected int overallPower;
    protected int cycleDuration;
    Vector<Vector<Boolean>> possibilityOperationVector = new Vector();
    Vector<Boolean> operationDaysVector = new Vector();
    Vector<Boolean> dailyOperation = new Vector();
    Vector<Vector<Boolean>> weeklyOperation = new Vector();
    Vector<Integer> loadVector = new Vector();
    Vector<Vector<Integer>> weeklyLoadVector = new Vector();
    int times;

    public int getPower() {
        return this.power;
    }

    public int getOverallPower() {
        return this.overallPower;
    }

    public Office getApplianceOf() {
        return this.applianceOf;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public int getDuration() {
        return this.cycleDuration;
    }

    public Vector<Vector<Boolean>> getWeeklyOperation() {
        return this.weeklyOperation;
    }

    public Vector<Vector<Integer>> getWeeklyLoadVector() {
        return this.weeklyLoadVector;
    }

    public Vector<Boolean> getOperationDaysVector() {
        return this.operationDaysVector;
    }

    public void setApplianceOf(Office office) {
        this.applianceOf = office;
    }

    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        return new Vector<Boolean>();
    }

    public void createWeeklyPossibilityOperationVector() {
        for (int i = 0; i < 7; ++i) {
            this.possibilityOperationVector.add(this.createDailyPossibilityOperationVector(i));
        }
    }

    public void initialize(String office, Properties conf, Random gen) {
    }

    public double[] dailyShifting(Tariff tariff, double[] nonDominantLoad, TariffEvaluationHelper tariffEvalHelper, int day, Random gen) {
        return new double[24];
    }

    boolean[] createShiftingOperationMatrix(int day) {
        boolean[] shiftingOperationMatrix = new boolean[24];
        for (int i = 0; i < 24; ++i) {
            boolean function;
            shiftingOperationMatrix[i] = function = this.possibilityOperationVector.get(day).get(i * 4) != false || this.possibilityOperationVector.get(day).get(i * 4 + 1) != false || this.possibilityOperationVector.get(day).get(i * 4 + 2) != false || this.possibilityOperationVector.get(day).get(i * 4 + 3) != false;
        }
        return shiftingOperationMatrix;
    }

    public void fillDailyOperation(int times, Random gen) {
    }

    public void fillWeeklyOperation(Random gen) {
        for (int i = 0; i < 7; ++i) {
            this.fillDailyOperation(i, gen);
        }
    }

    public void showStatus() {
        log.debug((Object)("Name = " + this.name));
        log.debug((Object)("Member Of = " + this.applianceOf.toString()));
        log.debug((Object)("Saturation = " + this.saturation));
        log.debug((Object)("Power = " + this.power));
        log.debug((Object)("Cycle Duration = " + this.cycleDuration));
        log.debug((Object)"Weekly Operation Vector and Load = ");
        for (int i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.debug((Object)("Day " + i));
            ListIterator<Boolean> iter = this.weeklyOperation.get(i).listIterator();
            ListIterator<Integer> iter2 = this.weeklyLoadVector.get(i).listIterator();
            for (int j = 0; j < 96; ++j) {
                log.debug((Object)("Quarter " + j + " = " + iter.next() + "   Load = " + iter2.next()));
            }
        }
    }

    public void weatherDailyFunction(int day, int hour, double temp) {
    }

    public void refresh(Random gen) {
    }

    public void setOperationDays() {
        for (int i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            boolean function = false;
            for (int j = 0; j < 96; ++j) {
                function = function || this.weeklyOperation.get(i).get(j) != false;
            }
            this.operationDaysVector.add(function);
        }
    }

    public void calculateOverallPower() {
        this.overallPower = -1;
    }

    public String toString() {
        return this.name;
    }
}

