/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.persons;

import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.powertac.officecomplexcustomer.enumerations.Status;
import org.powertac.officecomplexcustomer.persons.WorkingPerson;

public class PeriodicPresentPerson
extends WorkingPerson {
    @Override
    public void initialize(String AgentName, Properties conf, Vector<Integer> publicVacationVector, Random generator) {
        double sicknessMean = Double.parseDouble(conf.getProperty("SicknessMean"));
        double sicknessDev = Double.parseDouble(conf.getProperty("SicknessDev"));
        double workingDurationMean = Double.parseDouble(conf.getProperty("WorkingDurationMean"));
        double workingDurationDev = Double.parseDouble(conf.getProperty("WorkingDurationDev"));
        double breakDurationMean = Double.parseDouble(conf.getProperty("BreakDurationMean"));
        double breakDurationDev = Double.parseDouble(conf.getProperty("BreakDurationDev"));
        double vacationDurationMean = Double.parseDouble(conf.getProperty("VacationDurationMean"));
        double vacationDurationDev = Double.parseDouble(conf.getProperty("VacationDurationDev"));
        this.name = AgentName;
        this.status = Status.Home;
        this.gen = generator;
        this.sicknessVector = this.createSicknessVector(sicknessMean, sicknessDev, this.gen);
        this.publicVacationVector = publicVacationVector;
        this.workingStartHour = (int)(2.0 * this.gen.nextGaussian() + 32.0);
        int work = this.workingDaysRandomizer(conf, this.gen);
        this.workingDays = this.createWorkingDaysVector(work, this.gen);
        this.workingDuration = (int)(workingDurationDev * this.gen.nextGaussian() + workingDurationMean);
        this.breakDuration = (int)(breakDurationDev * this.gen.nextGaussian() + breakDurationMean);
        this.vacationDuration = (int)(vacationDurationDev * this.gen.nextGaussian() + vacationDurationMean);
        this.vacationVector = this.createVacationVector(Math.max(0, this.vacationDuration), this.gen);
    }

    @Override
    void fillWork() {
        Status st;
        for (int i = this.workingStartHour; i < this.workingStartHour + this.workingDuration; ++i) {
            st = Status.Working;
            this.dailyRoutine.set(i, st);
        }
        int breakStartHour = (int)(4.0 * this.gen.nextGaussian() + 52.0);
        breakStartHour = Math.max(breakStartHour, this.workingStartHour);
        for (int i = breakStartHour = Math.min(breakStartHour, this.workingStartHour + this.workingDuration); i < breakStartHour + this.breakDuration; ++i) {
            st = Status.Break;
            this.dailyRoutine.set(i, st);
        }
    }

    @Override
    public void refresh(Properties conf, Random gen) {
        for (int i = 0; i < 7; ++i) {
            this.fillDailyRoutine(i, gen);
            this.weeklyRoutine.add(this.dailyRoutine);
        }
    }
}

