/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.joda.time.Instant;
import org.powertac.common.Tariff;
import org.powertac.officecomplexcustomer.appliances.SemiShiftingAppliance;

public class MicrowaveOven
extends SemiShiftingAppliance {
    private double operationPercentage;

    @Override
    public void initialize(String office, Properties conf, Random gen) {
        this.name = office + " MicrowaveOven";
        this.saturation = Double.parseDouble(conf.getProperty("MicrowaveOvenSaturation"));
        this.power = (int)(307.0 * gen.nextGaussian() + 800.0);
        this.cycleDuration = 1;
        this.operationPercentage = 1.0;
        this.times = Integer.parseInt(conf.getProperty("MicrowaveOvenDailyTimes"));
    }

    @Override
    public void fillDailyOperation(int weekday, Random gen) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            double tempPercentage;
            this.dailyOperation.add(false);
            this.loadVector.add(0);
            if (!this.applianceOf.isOnBreak(weekday, i) || !((tempPercentage = this.operationPercentage + 0.02 * (double)this.applianceOf.employeeOnBreakNumber(weekday, i)) > gen.nextDouble()) || i <= 52 || i >= 60) continue;
            this.dailyOperation.set(i, true);
            this.loadVector.set(i, this.power);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isOnBreak(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public long[] dailyShifting(Tariff tariff, Instant now, int day, Random gen) {
        int i;
        long[] newControllableLoad = new long[24];
        int minindex = 0;
        double minvalue = Double.NEGATIVE_INFINITY;
        Instant hour1 = new Instant(now.getMillis() + 43200000L);
        long sumPower = 0L;
        for (i = 0; i < 96; ++i) {
            sumPower += (long)((Integer)((Vector)this.weeklyLoadVector.get(day)).get(i)).intValue();
        }
        for (i = 12; i < 17; ++i) {
            if (minvalue < tariff.getUsageCharge(hour1, 1.0, 0.0) || minvalue == tariff.getUsageCharge(hour1, 1.0, 0.0) && (double)gen.nextFloat() > 0.6) {
                minvalue = tariff.getUsageCharge(hour1, 1.0, 0.0);
                minindex = i;
            }
            hour1 = new Instant(hour1.getMillis() + 3600000L);
        }
        newControllableLoad[minindex] = sumPower;
        return newControllableLoad;
    }

    @Override
    public void refresh(Random gen) {
        this.fillWeeklyOperation(gen);
        this.createWeeklyPossibilityOperationVector();
    }
}

