/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.powertac.officecomplexcustomer.appliances.NotShiftingAppliance;

public class Servers
extends NotShiftingAppliance {
    private int sleepPower;

    @Override
    public void initialize(String office, Properties conf, Random gen) {
        this.name = office + " Servers";
        this.saturation = Double.parseDouble(conf.getProperty("ServersSaturation"));
        this.power = (int)(50.0 * gen.nextGaussian() + 450.0);
        this.sleepPower = (int)(15.0 * gen.nextGaussian() + 100.0);
        this.cycleDuration = 1;
        this.times = Integer.parseInt(conf.getProperty("ServersDailyTimes")) + this.applianceOf.getMembers().size() / 5;
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isWorking(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday, Random gen) {
        int i;
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        Vector<Integer> temp = new Vector<Integer>();
        for (i = 0; i < 96; ++i) {
            this.loadVector.add(this.sleepPower);
            this.dailyOperation.add(true);
            int count = this.applianceOf.employeeNumber(weekday, i);
            for (int j = 0; j < count; ++j) {
                temp.add(i);
            }
        }
        if (temp.size() > 0) {
            for (i = 0; i < this.times; ++i) {
                int rand = gen.nextInt(temp.size());
                int quarter = (Integer)temp.get(rand);
                this.loadVector.set(quarter, (Integer)this.loadVector.get(quarter) + this.power);
                temp.remove(rand);
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh(Random gen) {
        this.fillWeeklyOperation(gen);
        this.createWeeklyPossibilityOperationVector();
    }
}

