/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.joda.time.Instant;
import org.powertac.common.Tariff;
import org.powertac.officecomplexcustomer.appliances.FullyShiftingAppliance;

public class Refrigerator
extends FullyShiftingAppliance {
    @Override
    public void initialize(String office, Properties conf, Random gen) {
        this.name = office + " Refrigerator";
        this.saturation = Double.parseDouble(conf.getProperty("RefrigeratorSaturation"));
        this.power = (int)(23.0 * gen.nextGaussian() + 140.0);
        this.cycleDuration = 2;
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            possibilityDailyOperation.add(true);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday, Random gen) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        int k = gen.nextInt(this.cycleDuration);
        for (int i = 0; i < 96; ++i) {
            if (i % this.cycleDuration == k) {
                this.loadVector.add(this.power);
                this.dailyOperation.add(true);
                continue;
            }
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public long[] dailyShifting(Tariff tariff, Instant now, int day, Random gen) {
        long[] newControllableLoad = new long[24];
        Instant now2 = now;
        for (int i = 0; i < 12; ++i) {
            double minvalue = Double.NEGATIVE_INFINITY;
            int minindex = 0;
            for (int j = 0; j < 2; ++j) {
                if (minvalue < tariff.getUsageCharge(now2, 1.0, 0.0) || minvalue == tariff.getUsageCharge(now2, 1.0, 0.0) && (double)gen.nextFloat() > 0.6) {
                    minvalue = tariff.getUsageCharge(now2, 1.0, 0.0);
                    minindex = j;
                }
                now2 = new Instant(now2.getMillis() + 3600000L);
            }
            newControllableLoad[2 * i + minindex] = 4 * this.power;
        }
        return newControllableLoad;
    }

    @Override
    public void refresh(Random gen) {
        this.fillWeeklyOperation(gen);
        this.createWeeklyPossibilityOperationVector();
    }
}

