/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.joda.time.Instant;
import org.powertac.common.Tariff;
import org.powertac.officecomplexcustomer.appliances.FullyShiftingAppliance;

public class CoffeeMachine
extends FullyShiftingAppliance {
    int standByPower;

    @Override
    public void initialize(String office, Properties conf, Random gen) {
        this.name = office + " CoffeeMachine";
        this.saturation = Double.parseDouble(conf.getProperty("RefrigeratorSaturation"));
        this.power = (int)(23.0 * gen.nextGaussian() + 100.0);
        this.cycleDuration = 4;
        this.standByPower = this.power / (this.cycleDuration - 1);
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isWorking(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday, Random gen) {
        int i;
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        int k = gen.nextInt(this.cycleDuration);
        for (i = 0; i < 96; ++i) {
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        if (this.applianceOf.isWorkingDayOfWeek(weekday)) {
            for (i = 32; i < 72; ++i) {
                if (i % this.cycleDuration == k) {
                    this.loadVector.set(i, this.power);
                    this.dailyOperation.set(i, true);
                    continue;
                }
                this.loadVector.set(i, this.standByPower);
                this.dailyOperation.set(i, true);
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public long[] dailyShifting(Tariff tariff, Instant now, int day, Random gen) {
        long[] newControllableLoad = new long[24];
        if (this.applianceOf.isWorkingDay(day)) {
            Instant now2 = new Instant(now.getMillis() + 28800000L);
            for (int i = 0; i < 5; ++i) {
                double minvalue = Double.NEGATIVE_INFINITY;
                int minindex = 0;
                for (int j = 0; j < 2; ++j) {
                    if (minvalue < tariff.getUsageCharge(now2, 1.0, 0.0) || minvalue == tariff.getUsageCharge(now2, 1.0, 0.0) && (double)gen.nextFloat() > 0.6) {
                        minvalue = tariff.getUsageCharge(now2, 1.0, 0.0);
                        minindex = j;
                    }
                    now2 = new Instant(now2.getMillis() + 3600000L);
                }
                newControllableLoad[8 + 2 * i + minindex] = 2 * this.power + 6 * this.standByPower;
            }
        }
        return newControllableLoad;
    }

    @Override
    public void refresh(Random gen) {
        this.fillWeeklyOperation(gen);
        this.createWeeklyPossibilityOperationVector();
    }
}

