/*
 * Decompiled with CFR 0.152.
 */
package samples.classwithinnermembers;

public class ClassWithInnerMembers {
    public String getValue() {
        return new MyInnerClass().doStuff();
    }

    public String getValueForInnerClassWithConstructorArgument() {
        return new MyInnerClassWithConstructorArgument("value").doStuff();
    }

    public String getValueForStaticInnerClassWithConstructorArgument() {
        return new StaticInnerClassWithConstructorArgument("value").doStuff();
    }

    public String getLocalClassValue() {
        class MyLocalClass
        implements InnerInterface {
            MyLocalClass() {
            }

            @Override
            public String doStuff() {
                return "local class";
            }
        }
        return new MyLocalClass().doStuff();
    }

    public String getLocalClassValueWithArgument() {
        class MyLocalClass
        implements InnerInterface {
            private final String value;

            public MyLocalClass(String value) {
                this.value = value;
            }

            @Override
            public String doStuff() {
                return this.value;
            }
        }
        return new MyLocalClass("my value").doStuff();
    }

    public String getValueForAnonymousInnerClass() {
        InnerInterface inner = new InnerInterface(){

            @Override
            public String doStuff() {
                return "value";
            }
        };
        return inner.doStuff();
    }

    private class MyInnerClassWithConstructorArgument
    implements InnerInterface {
        private final String value;

        public MyInnerClassWithConstructorArgument(String value) {
            this.value = value;
        }

        @Override
        public String doStuff() {
            return this.value;
        }
    }

    private static class StaticInnerClassWithConstructorArgument
    implements InnerInterface {
        private final String value;

        public StaticInnerClassWithConstructorArgument(String value) {
            this.value = value;
        }

        @Override
        public String doStuff() {
            return this.value;
        }
    }

    private static class MyInnerClass
    implements InnerInterface {
        private MyInnerClass() {
        }

        @Override
        public String doStuff() {
            return "member class";
        }
    }

    private static interface InnerInterface {
        public String doStuff();
    }
}

