/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.testng;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.reporter.MockingFrameworkReporter;
import org.powermock.core.reporter.MockingFrameworkReporterFactory;
import org.powermock.reflect.Whitebox;
import org.testng.IObjectFactory;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.ObjectFactory;

public class PowerMockTestCase {
    private Object annotationEnabler;
    private ClassLoader previousCl = null;
    private MockingFrameworkReporter frameworkReporter;

    public PowerMockTestCase() {
        try {
            Class<?> annotationEnablerClass = Class.forName("org.powermock.api.extension.listener.AnnotationEnabler");
            this.annotationEnabler = Whitebox.newInstance(annotationEnablerClass);
        }
        catch (ClassNotFoundException e) {
            this.annotationEnabler = null;
        }
    }

    @BeforeClass
    protected void beforePowerMockTestClass() throws Exception {
        MockRepository.clear();
        if (this.isLoadedByPowerMockClassloader()) {
            Thread thread = Thread.currentThread();
            this.previousCl = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getClass().getClassLoader());
        }
    }

    @AfterClass
    protected void afterPowerMockTestClass() throws Exception {
        if (this.previousCl != null) {
            Thread.currentThread().setContextClassLoader(this.previousCl);
        }
    }

    @BeforeMethod
    protected void beforePowerMockTestMethod() throws Exception {
        this.injectMocks();
        this.enableReporter();
    }

    private void enableReporter() {
        this.frameworkReporter = this.getFrameworkReporterFactory().create();
        this.frameworkReporter.enable();
    }

    private MockingFrameworkReporterFactory getFrameworkReporterFactory() {
        Class<?> mockingFrameworkReporterFactoryClass;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            mockingFrameworkReporterFactoryClass = classLoader.loadClass("org.powermock.api.extension.reporter.MockingFrameworkReporterFactoryImpl");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Extension API internal error: org.powermock.api.org.powermock.api.extension.reporter.MockingFrameworkReporterFactoryImpl could not be located in classpath.");
        }
        return (MockingFrameworkReporterFactory)Whitebox.newInstance(mockingFrameworkReporterFactoryClass);
    }

    @AfterMethod
    protected void afterPowerMockTestMethod() throws Exception {
        try {
            this.clearMockFields();
        }
        finally {
            MockRepository.clear();
        }
        this.disableReporter();
    }

    private void disableReporter() {
        this.frameworkReporter.disable();
    }

    @ObjectFactory
    public IObjectFactory create(ITestContext context) {
        try {
            Class<?> powerMockObjectFactory = Class.forName("org.powermock.modules.testng.PowerMockObjectFactory");
            return (IObjectFactory)powerMockObjectFactory.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Missing org.powermock.modules.testng.PowerMockObjectFactory in classpath.");
        }
        catch (Exception e) {
            throw new RuntimeException("PowerMock internal error", e);
        }
    }

    private void clearMockFields() throws Exception, IllegalAccessException {
        if (this.annotationEnabler != null) {
            Class[] mockAnnotations = (Class[])Whitebox.invokeMethod((Object)this.annotationEnabler, (String)"getMockAnnotations", (Object[])new Object[0]);
            Set mockFields = Whitebox.getFieldsAnnotatedWith((Object)this, (Class[])mockAnnotations);
            for (Field field : mockFields) {
                field.set(this, null);
            }
        }
    }

    private void injectMocks() throws Exception {
        if (this.annotationEnabler != null) {
            Whitebox.invokeMethod((Object)this.annotationEnabler, (String)"beforeTestMethod", (Class[])new Class[]{Object.class, Method.class, Object[].class}, (Object[])new Object[]{this, null, null});
        }
    }

    private boolean isLoadedByPowerMockClassloader() {
        return this.getClass().getClassLoader() instanceof MockClassLoader;
    }
}

