/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl;

import java.lang.reflect.Method;
import java.util.LinkedList;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.powermock.core.testlisteners.GlobalNotificationBuildSupport;
import org.powermock.modules.junit4.internal.impl.NotificationBuilder;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.PowerMockTestNotifier;

class PowerMockRunNotifier
extends RunNotifier
implements GlobalNotificationBuildSupport.Callback {
    private Class<?> suiteClass = null;
    private final Thread motherThread = Thread.currentThread();
    private final RunNotifier junitRunNotifier;
    private final PowerMockTestNotifier powerMockTestNotifier;
    private final Method[] testMethods;
    private final LinkedList<Object> pendingTestInstancesOnMotherThread = new LinkedList();
    private final ThreadLocal<NotificationBuilder> notificationBuilder = new ThreadLocal<NotificationBuilder>(){

        @Override
        protected NotificationBuilder initialValue() {
            return new NotificationBuilder((Method[])PowerMockRunNotifier.this.testMethods.clone(), PowerMockRunNotifier.this.powerMockTestNotifier, PowerMockRunNotifier.this.pendingTestInstancesOnMotherThread);
        }
    };

    PowerMockRunNotifier(RunNotifier junitRunNotifier, PowerMockTestNotifier powerMockTestNotifier, Method[] testMethods) {
        this.junitRunNotifier = junitRunNotifier;
        this.powerMockTestNotifier = powerMockTestNotifier;
        this.testMethods = testMethods;
    }

    Class<?> getSuiteClass() {
        return this.suiteClass;
    }

    public void suiteClassInitiated(Class<?> testClass) {
        this.suiteClass = testClass;
        this.notificationBuilder.get().testSuiteStarted(testClass);
    }

    public void testInstanceCreated(Object testInstance) {
        if (Thread.currentThread() == this.motherThread) {
            this.pendingTestInstancesOnMotherThread.add(testInstance);
        }
        this.notificationBuilder.get().testInstanceCreated(testInstance);
    }

    public void addListener(RunListener listener) {
        this.invoke("addListener", listener);
    }

    public void removeListener(RunListener listener) {
        this.invoke("removeListener", listener);
    }

    public void fireTestRunStarted(Description description) {
        this.invoke("fireTestRunStarted", description);
    }

    public void fireTestRunFinished(Result result) {
        this.invoke("fireTestRunFinished", result);
    }

    public void fireTestStarted(Description description) throws StoppedByUserException {
        this.invoke("fireTestStarted", description);
        this.notificationBuilder.get().testStartHasBeenFired(description);
    }

    public void fireTestFailure(Failure failure) {
        this.notificationBuilder.get().failure(failure);
        this.invoke("fireTestFailure", failure);
    }

    public void fireTestAssumptionFailed(Failure failure) {
        this.notificationBuilder.get().assumptionFailed(failure.getDescription());
        this.invoke("fireTestAssumptionFailed", failure);
    }

    public void fireTestIgnored(Description description) {
        this.notificationBuilder.get().testIgnored(description);
        this.invoke("fireTestIgnored", description);
    }

    public void fireTestFinished(Description description) {
        try {
            this.notificationBuilder.get().testFinished(description);
        }
        catch (Throwable failure) {
            this.fireTestFailure(new Failure(description, failure));
            return;
        }
        this.invoke("fireTestFinished", description);
    }

    public void pleaseStop() {
        this.invoke("pleaseStop", new Object[0]);
    }

    public void addFirstListener(RunListener listener) {
        this.invoke("addFirstListener", listener);
    }

    private void invoke(String methodName, Object ... args) {
        try {
            Whitebox.invokeMethod((Object)this.junitRunNotifier, (String)methodName, (Object[])args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

