/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.junit.Rule;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestMethod;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.modules.junit4.internal.impl.PowerMockJUnit44RunnerDelegateImpl;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockJUnit47RunnerDelegateImpl
extends PowerMockJUnit44RunnerDelegateImpl {
    public boolean hasRules;

    public PowerMockJUnit47RunnerDelegateImpl(Class<?> klass, String[] methodsToRun, PowerMockTestListener[] listeners) throws InitializationError {
        super(klass, methodsToRun, listeners);
    }

    public PowerMockJUnit47RunnerDelegateImpl(Class<?> klass, String[] methodsToRun) throws InitializationError {
        super(klass, methodsToRun);
    }

    public PowerMockJUnit47RunnerDelegateImpl(Class<?> klass) throws InitializationError {
        super(klass);
    }

    @Override
    protected PowerMockJUnit44RunnerDelegateImpl.PowerMockJUnit44MethodRunner createPowerMockRunner(Object testInstance, TestMethod testMethod, RunNotifier notifier, Description description, boolean extendsFromTestCase) {
        return new PowerMockJUnit47MethodRunner(testInstance, testMethod, notifier, description, extendsFromTestCase);
    }

    protected class PowerMockJUnit47MethodRunner
    extends PowerMockJUnit44RunnerDelegateImpl.PowerMockJUnit44MethodRunner {
        private Throwable potentialTestFailure;

        protected PowerMockJUnit47MethodRunner(Object testInstance, TestMethod method, RunNotifier notifier, Description description, boolean extendsFromTestCase) {
            super(testInstance, method, notifier, description, extendsFromTestCase);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeTest(Method method, Object testInstance, Runnable test) {
            Set rules;
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                rules = Whitebox.getFieldsAnnotatedWith((Object)testInstance, Rule.class, (Class[])new Class[0]);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
            boolean bl = PowerMockJUnit47RunnerDelegateImpl.this.hasRules = !rules.isEmpty();
            if (!PowerMockJUnit47RunnerDelegateImpl.this.hasRules) {
                this.executeTestInSuper(method, testInstance, test);
            } else {
                int processedFields = 0;
                for (Field field : rules) {
                    ++processedFields;
                    try {
                        LastRuleTestExecutorStatement lastStatement = new LastRuleTestExecutorStatement(processedFields, rules.size(), test, testInstance, method);
                        Statement statement = this.applyRuleToLastStatement(method, testInstance, field, lastStatement);
                        statement.evaluate();
                    }
                    catch (Throwable e) {
                        super.handleException(this.testMethod, this.potentialTestFailure == null ? e : this.potentialTestFailure);
                    }
                }
            }
        }

        protected Statement applyRuleToLastStatement(Method method, Object testInstance, Field field, LastRuleTestExecutorStatement lastStatement) throws IllegalAccessException {
            MethodRule rule = (MethodRule)field.get(testInstance);
            Statement statement = rule.apply((Statement)lastStatement, new FrameworkMethod(method), testInstance);
            return statement;
        }

        protected void handleException(TestMethod testMethod, Throwable actualFailure) {
            if (PowerMockJUnit47RunnerDelegateImpl.this.hasRules) {
                this.potentialTestFailure = actualFailure;
            } else {
                super.handleException(testMethod, actualFailure);
            }
        }

        private void executeTestInSuper(Method method, Object testInstance, Runnable test) {
            super.executeTest(method, testInstance, test);
        }

        protected final class LastRuleTestExecutorStatement
        extends Statement {
            private final Runnable test;
            private final Object testInstance;
            private final Method method;
            private final int noOfRules;
            private final int currentRule;

            private LastRuleTestExecutorStatement(int currentRuleNumber, int noOfRules, Runnable test, Object testInstance, Method method) {
                this.currentRule = currentRuleNumber;
                this.noOfRules = noOfRules;
                this.test = test;
                this.testInstance = testInstance;
                this.method = method;
            }

            public void evaluate() throws Throwable {
                if (this.currentRule == this.noOfRules) {
                    PowerMockJUnit47MethodRunner.this.executeTestInSuper(this.method, this.testInstance, this.test);
                    if (PowerMockJUnit47MethodRunner.this.potentialTestFailure != null) {
                        throw PowerMockJUnit47MethodRunner.this.potentialTestFailure;
                    }
                }
            }
        }
    }
}

