/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit3.internal.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.modules.junit3.internal.PowerMockJUnit3RunnerDelegate;

public class PowerMockJUnit3RunnerDelegateImpl
extends TestSuite
implements PowerMockJUnit3RunnerDelegate {
    private final Method[] methodsToRun;
    private Class<?> testClass;

    public PowerMockJUnit3RunnerDelegateImpl(Class<?> theClass, Method[] methodsToRun, String name, PowerMockTestListener[] powerListeners) {
        this(theClass, methodsToRun, powerListeners);
        this.testClass = theClass;
        this.setName(name);
    }

    public PowerMockJUnit3RunnerDelegateImpl(Class<?> theClass, Method[] methodsToRun, PowerMockTestListener[] powerMockTestListeners) {
        Method[] declaredMethods;
        this.testClass = theClass;
        this.methodsToRun = methodsToRun;
        this.setName(theClass.getName());
        try {
            PowerMockJUnit3RunnerDelegateImpl.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e) {
            this.addTest(PowerMockJUnit3RunnerDelegateImpl.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(PowerMockJUnit3RunnerDelegateImpl.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class<?> superClass = theClass;
        Vector names = new Vector();
        Method addTestMethod = null;
        for (Method method : declaredMethods = TestSuite.class.getDeclaredMethods()) {
            if (!method.getName().equals("addTestMethod")) continue;
            addTestMethod = method;
        }
        if (addTestMethod == null) {
            throw new RuntimeException("Internal error: Failed to get addTestMethod for JUnit3.");
        }
        addTestMethod.setAccessible(true);
        while (Test.class.isAssignableFrom(superClass)) {
            for (int i = 0; i < methodsToRun.length; ++i) {
                try {
                    addTestMethod.invoke((Object)this, methodsToRun[i], names, theClass);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Internal error: Failed to execute addTestMethod for JUnit3.");
                }
            }
            superClass = superClass.getSuperclass();
        }
        if (this.testCount() == 0) {
            this.addTest(PowerMockJUnit3RunnerDelegateImpl.warning("No tests found in " + theClass.getName()));
        }
    }

    @Override
    public Class<?> getTestClass() {
        return this.testClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TestResult result) {
        ClassLoader classloader = this.getClass().getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(classloader);
        try {
            super.run(result);
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    public static Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)message);
            }
        };
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Methods ran by this test runner delegate:\n");
        for (Method method : this.methodsToRun) {
            builder.append(method).append("\n");
        }
        return builder.toString();
    }
}

