/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.powermock.modules.agent.PowerMockClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PowerMockClassTransformer
implements ClassFileTransformer {
    private static final List<String> STARTS_WITH_IGNORED = new LinkedList<String>();
    private static final List<String> CONTAINS_IGNORED = new LinkedList<String>();

    PowerMockClassTransformer() {
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (loader == null || this.shouldIgnore(className)) {
            return classfileBuffer;
        }
        try {
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(1);
            reader.accept(new PowerMockClassVisitor(writer), 4);
            return writer.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to redefine class " + className, e);
        }
    }

    private boolean shouldIgnore(String className) {
        for (String ignore : STARTS_WITH_IGNORED) {
            if (!className.startsWith(ignore)) continue;
            return true;
        }
        for (String ignore : CONTAINS_IGNORED) {
            if (!className.contains(ignore)) continue;
            return true;
        }
        return false;
    }

    static {
        STARTS_WITH_IGNORED.add("org/powermock");
        STARTS_WITH_IGNORED.add("org/junit");
        STARTS_WITH_IGNORED.add("org/mockito");
        STARTS_WITH_IGNORED.add("javassist");
        STARTS_WITH_IGNORED.add("org/objenesis");
        STARTS_WITH_IGNORED.add("junit");
        STARTS_WITH_IGNORED.add("org/hamcrest");
        STARTS_WITH_IGNORED.add("sun/");
        STARTS_WITH_IGNORED.add("$Proxy");
        CONTAINS_IGNORED.add("CGLIB$$");
        CONTAINS_IGNORED.add("$$PowerMock");
    }
}

